/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.util.DoNothingCompletionProposal;
import org.eclipse.papyrus.infra.widgets.util.INameResolutionHelper;
import org.eclipse.papyrus.uml.properties.editors.AutoCompleteStyledTextStringEditor;
import org.eclipse.papyrus.uml.properties.editors.NamedElementCompletionProposal;
import org.eclipse.papyrus.uml.tools.utils.NameResolutionHelper;
import org.eclipse.uml2.uml.NamedElement;

public class UMLReferenceContentAssistProcessor
implements IContentAssistProcessor {
    private static int MAX_ELEMENTS_TO_DISPLAY = 15;
    public static final String MORE_ELEMENTS = "...";
    private String lastError = null;
    private IContextInformationValidator contextInfoValidator;
    private NameResolutionHelper nameResolutionHelper;
    private AutoCompleteStyledTextStringEditor autoCompleteStyledTextStringEditor;
    private EReference eReference;

    public UMLReferenceContentAssistProcessor(EReference eReference, NameResolutionHelper nameResolutionHelper, AutoCompleteStyledTextStringEditor autoCompleteStyledTextStringEditor) {
        this.eReference = eReference;
        this.nameResolutionHelper = nameResolutionHelper;
        this.autoCompleteStyledTextStringEditor = autoCompleteStyledTextStringEditor;
    }

    public INameResolutionHelper getNameResolutionHelper() {
        return this.nameResolutionHelper;
    }

    public void setNameResolutionHelper(NameResolutionHelper nameResolutionHelper) {
        this.nameResolutionHelper = nameResolutionHelper;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer textViewer, int documentOffset) {
        IDocument document = textViewer.getDocument();
        int currOffset = documentOffset - 1;
        String stringToComplete = textViewer.getTextWidget().getText();
        try {
            char currChar;
            String currWord = "";
            while (currOffset > 0 && !Character.isWhitespace(currChar = document.getChar(currOffset))) {
                currWord = String.valueOf(currChar) + currWord;
                --currOffset;
            }
            currWord = textViewer.getTextWidget().getText();
            ICompletionProposal[] proposals = this.buildProposals(stringToComplete, documentOffset - stringToComplete.length());
            this.lastError = proposals.length > 0 ? null : "There is no suggestion for you.";
            return proposals;
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
            this.lastError = e.getMessage();
            return null;
        }
    }

    private ICompletionProposal[] buildProposals(final String entry, int offset) {
        ArrayList<NamedElementCompletionProposal> proposalList = new ArrayList<NamedElementCompletionProposal>();
        List matchingElements = this.nameResolutionHelper.getMatchingElements((Predicate)new Predicate<NamedElement>(){

            @Override
            public boolean test(NamedElement namedElement) {
                return namedElement.getName().regionMatches(true, 0, entry, 0, entry.length());
            }
        });
        Collections.sort(matchingElements, new Comparator<NamedElement>(){

            @Override
            public int compare(NamedElement o1, NamedElement o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        Object contextElement = this.autoCompleteStyledTextStringEditor.getContextElement();
        int i = 0;
        while (i < matchingElements.size() && i < MAX_ELEMENTS_TO_DISPLAY) {
            NamedElement suggestedNamedElement = (NamedElement)matchingElements.get(i);
            NamedElementCompletionProposal ccc = new NamedElementCompletionProposal((EStructuralFeature)this.eReference, suggestedNamedElement, (EObject)contextElement, offset, entry.length(), suggestedNamedElement.getName().length());
            proposalList.add(ccc);
            ++i;
        }
        NamedElementCompletionProposal resetProposal = new NamedElementCompletionProposal((EStructuralFeature)this.eReference, null, (EObject)contextElement, "", 0, entry.length() + offset, "<Undefined>".length(), null, "<Undefined>", null, null);
        proposalList.add(0, resetProposal);
        if (matchingElements.size() > MAX_ELEMENTS_TO_DISPLAY) {
            DoNothingCompletionProposal doNothingCompletionProposal = new DoNothingCompletionProposal("", 0, entry.length() + offset, MORE_ELEMENTS.length(), null, MORE_ELEMENTS, null, null);
            proposalList.add((NamedElementCompletionProposal)doNothingCompletionProposal);
        }
        return proposalList.toArray(new ICompletionProposal[0]);
    }

    public IContextInformation[] computeContextInformation(ITextViewer textViewer, int documentOffset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return this.lastError;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.contextInfoValidator;
    }
}

