/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.emf.internal.facet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IDialogSettingsProvider;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationCatalogManager;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationCatalogManagerFactory;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.papyrus.infra.emf.CustomizationComparator;
import org.eclipse.papyrus.infra.ui.emf.internal.facet.ICustomizationManagerUpdater;
import org.eclipse.papyrus.infra.ui.internal.emf.Activator;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class WorskpaceCustomizationUpdater
implements ICustomizationManagerUpdater {
    private ICustomizationManager customizationManager = org.eclipse.papyrus.infra.emf.Activator.getDefault().getCustomizationManager();
    protected static final String DEFAULT_LOADED_FACET = "defaultLoadedFacet";
    protected static final String SEPARATOR_DEFAULT_LOADED_FACET = ",";
    protected static final String CUSTOMIZATION_MANAGER_SECTION = "org.eclipse.papyrus.infra.ui.emf.customizationManager";
    protected static final String LOADED_FACET_ORDER = "org.eclipse.papyrus.infra.ui.emf.facet.order";

    @Override
    public void applyCustomizations() {
        if (this.hasCustomizationPreferences()) {
            this.applyCustomizationFromUserPreferences();
        } else {
            this.applyDefaultLoadedCustomizationCatalog();
        }
    }

    protected final boolean hasCustomizationPreferences() {
        return this.getBrowserCustomizationDialogSettings() != null;
    }

    protected IDialogSettings getBrowserCustomizationDialogSettings() {
        return this.getWorkspaceBrowserCustomizationDialogSettings();
    }

    protected final IDialogSettings getWorkspaceBrowserCustomizationDialogSettings() {
        return this.getDialogSettingProvider().getDialogSettings().getSection(CUSTOMIZATION_MANAGER_SECTION);
    }

    protected IDialogSettings getOrCreateBrowserCustomizationDialogSettings() {
        return this.getOrCreateWorkspaceBrowserCustomizationDialogSettings();
    }

    protected final IDialogSettings getOrCreateWorkspaceBrowserCustomizationDialogSettings() {
        IDialogSettings settings = this.getWorkspaceBrowserCustomizationDialogSettings();
        if (settings == null) {
            settings = this.getDialogSettingProvider().getDialogSettings().addNewSection(CUSTOMIZATION_MANAGER_SECTION);
            String loadedFacetPreferences = Activator.getDefault().getPreferenceStore().getString(DEFAULT_LOADED_FACET);
            if (loadedFacetPreferences != null && !"".equals(loadedFacetPreferences)) {
                settings.put(LOADED_FACET_ORDER, loadedFacetPreferences.split(SEPARATOR_DEFAULT_LOADED_FACET));
            }
        }
        return settings;
    }

    @Override
    public void applyCustomizations(List<Customization> customizationsToApply) {
        if (this.customizationManager != null) {
            if (this.customizationManager.getManagedCustomizations().size() > 0) {
                this.customizationManager.getManagedCustomizations().clear();
            }
            this.customizationManager.getManagedCustomizations().addAll(customizationsToApply);
        }
    }

    protected final void applyDefaultLoadedCustomizationCatalog() {
        ICustomizationCatalogManager customCatalog = ICustomizationCatalogManagerFactory.DEFAULT.getOrCreateCustomizationCatalogManager(this.customizationManager.getResourceSet());
        List registryAllCustomizations = customCatalog.getRegisteredCustomizations();
        ArrayList<Customization> orderedCustomizationList = new ArrayList<Customization>();
        for (Customization customization : registryAllCustomizations) {
            if (!customization.isMustBeLoadedByDefault()) continue;
            orderedCustomizationList.add(customization);
        }
        Collections.sort(orderedCustomizationList, new CustomizationComparator());
        this.applyCustomizations(orderedCustomizationList);
    }

    protected final void applyCustomizationFromUserPreferences() {
        IDialogSettings settings = this.getBrowserCustomizationDialogSettings();
        try {
            ICustomizationCatalogManager customCatalog = ICustomizationCatalogManagerFactory.DEFAULT.getOrCreateCustomizationCatalogManager(this.customizationManager.getResourceSet());
            List registryAllCustomizations = customCatalog.getRegisteredCustomizations();
            List<Object> orderedCustomizationList = new ArrayList<Customization>();
            for (Customization customization : registryAllCustomizations) {
                String settingKey = this.getSettingKey(customization);
                if (!settings.getBoolean(settingKey)) continue;
                orderedCustomizationList.add(customization);
            }
            String[] loadedFacetOrder = settings.getArray(LOADED_FACET_ORDER);
            if (loadedFacetOrder != null && loadedFacetOrder.length > 0) {
                Map<String, Customization> mapProp = registryAllCustomizations.stream().collect(Collectors.toMap(e -> this.getSettingKey((Customization)e), e -> e));
                Stream<String> stream = Arrays.stream(loadedFacetOrder);
                Stream<Customization> map = stream.map(id -> (Customization)mapProp.get(id.trim()));
                orderedCustomizationList = map.collect(Collectors.toList());
            } else {
                Collections.sort(orderedCustomizationList, new CustomizationComparator());
            }
            this.applyCustomizations(orderedCustomizationList);
        }
        catch (Throwable e2) {
            Activator.log.log((IStatus)new Status(4, "org.eclipse.papyrus.infra.ui.emf", "Error applying customization from the preferences", e2));
        }
    }

    @Override
    public void resetToDefaultCustomizations() {
        this.destroyUserPreferences();
        this.applyCustomizations();
    }

    protected void destroyUserPreferences() {
        IDialogSettings settings = this.getBrowserCustomizationDialogSettings();
        if (settings instanceof DialogSettings) {
            ((DialogSettings)settings).removeSection(CUSTOMIZATION_MANAGER_SECTION);
        }
    }

    @Override
    public void saveUserCustomizationsState() {
        IDialogSettings dialogSettings = this.getOrCreateBrowserCustomizationDialogSettings();
        List appliedCustomizations = this.customizationManager.getManagedCustomizations();
        List registeredCustomizations = ICustomizationCatalogManagerFactory.DEFAULT.getOrCreateCustomizationCatalogManager(this.customizationManager.getResourceSet()).getRegisteredCustomizations();
        for (Customization customization2 : registeredCustomizations) {
            boolean isApplied = appliedCustomizations.contains(customization2);
            String settingKey = this.getSettingKey(customization2);
            dialogSettings.put(settingKey, isApplied);
        }
        ArrayList customizationList = new ArrayList();
        customizationList.addAll(appliedCustomizations);
        String[] loadedCustomizationArray = (String[])customizationList.stream().map(customization -> customization.eResource().getURI().toString()).toArray(String[]::new);
        dialogSettings.put(LOADED_FACET_ORDER, loadedCustomizationArray);
    }

    protected final IDialogSettingsProvider getDialogSettingProvider() {
        return PlatformUI.getDialogSettingsProvider((Bundle)Activator.getDefault().getBundle());
    }

    protected final String getSettingKey(Customization customization) {
        return customization.eResource().getURI().toString();
    }

    @Override
    public ICustomizationManager getCustomizationManager() {
        return this.customizationManager;
    }
}

