/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.checkers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.toolsmiths.validation.common.Activator;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.AbstractPluginChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker2;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.OpaqueResourceProvider;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.messages.Messages;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.ProjectManagementService;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ModelDependenciesChecker
extends AbstractPluginChecker {
    private static final String BUNDLE_RESOURCE_SCHEME = "bundleresource";
    private static final String BUNDLE_CLASS_SCHEME = "bundleclass";
    private final Resource resource;
    private final Set<String> additionalRequirements = new HashSet<String>();
    private final List<Function<? super Resource, ? extends Collection<String>>> additionalRequirementsFunctions = new ArrayList<Function<? super Resource, ? extends Collection<String>>>();
    private ToIntFunction<? super String> severityFunction = __ -> 4;
    private OpaqueResourceProvider.EMF opaqueResourceProvider;
    private final Pattern bundleResourceAuthorityPattern = Pattern.compile("^\\d+");

    public ModelDependenciesChecker(IProject project, IFile modelFile, Resource resource) {
        super(project, modelFile);
        this.resource = resource;
    }

    public ModelDependenciesChecker(IProject project, IFile modelFile, Resource resource, String markerType) {
        super(project, modelFile, markerType);
        this.resource = resource;
    }

    public ModelDependenciesChecker withSeverityFunction(ToIntFunction<? super String> severityFunction) {
        this.severityFunction = severityFunction != null ? severityFunction : __ -> 4;
        return this;
    }

    public ModelDependenciesChecker addRequirement(String bundleSymbolicName) {
        this.additionalRequirements.add(bundleSymbolicName);
        return this;
    }

    public ModelDependenciesChecker addRequirements(Collection<String> bundleSymbolicNames) {
        this.additionalRequirements.addAll(bundleSymbolicNames);
        return this;
    }

    public ModelDependenciesChecker addRequirements(Function<? super Resource, ? extends Collection<String>> bundleSymbolicNamesFunction) {
        this.additionalRequirementsFunctions.add(bundleSymbolicNamesFunction);
        return this;
    }

    public ModelDependenciesChecker withReferencedResources(OpaqueResourceProvider.EMF opaqueReferenceProvider) {
        this.opaqueResourceProvider = OpaqueResourceProvider.and(opaqueReferenceProvider, this.opaqueResourceProvider);
        return this;
    }

    @Override
    public void check(DiagnosticChain diagnostics, IProgressMonitor monitor) {
        String resourceName = this.getModelFile() == null ? this.getProject().getName() : this.getModelFile().getName();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.ModelDependenciesChecker_0, (Object)resourceName), (int)3);
        Collection<URI> externalReferencesPaths = this.getExternalReferencesPaths(diagnostics, this.getProject(), this.getModelFile(), this.resource);
        subMonitor.worked(1);
        HashSet<String> requiredPlugins = new HashSet<String>(this.additionalRequirements);
        externalReferencesPaths.stream().map(uri -> this.getPluginNameFromURI((URI)uri, diagnostics)).filter(Objects::nonNull).forEach(requiredPlugins::add);
        if (this.resource != null && !this.additionalRequirementsFunctions.isEmpty()) {
            this.additionalRequirementsFunctions.stream().map(f -> (Collection)f.apply(this.resource)).forEach(requiredPlugins::addAll);
        }
        if (this.opaqueResourceProvider != null) {
            this.opaqueResourceProvider.processModel(this.getProject(), this.getModelFile(), this.resource, diagnostics, uri -> this.getPluginNameFromURI(uri.uri(), diagnostics), requiredPlugins::add);
        }
        requiredPlugins.remove(this.getBundleName(this.getProject()));
        List<BundleSpecification> dependencies = ProjectManagementService.getPluginDependencies(this.getProject());
        if (dependencies != null && !dependencies.isEmpty()) {
            dependencies.stream().map(VersionConstraint::getName).forEach(requiredPlugins::remove);
        }
        subMonitor.worked(1);
        ArrayList<ManifestError> errors = new ArrayList<ManifestError>();
        if (!requiredPlugins.isEmpty()) {
            requiredPlugins.stream().forEach(requiredPlugin -> {
                int severity = this.severityFunction.applyAsInt((String)requiredPlugin);
                errors.add(new ManifestError(this.getMarkerType(), Messages.ModelDependenciesChecker_1, severity, "Require-Bundle", resourceName, (String)requiredPlugin));
            });
            this.reportErrors(diagnostics, errors);
        }
        subMonitor.worked(1);
        SubMonitor.done((IProgressMonitor)monitor);
    }

    private void reportErrors(DiagnosticChain diagnostics, List<ManifestError> errors) {
        if (!errors.isEmpty()) {
            IFile manifestFile = ProjectManagementService.getManifestFile((IContainer)this.getProject());
            BundleModel textBundleModel = this.prepareTextBundleModel(manifestFile);
            errors.stream().forEach(error -> this.reportBundleError(diagnostics, manifestFile, textBundleModel, error.type, error.message, error.severity, error.header, error.dependentName, error.dependencyName));
        }
    }

    private void reportBundleError(DiagnosticChain diagnostics, IFile manifestFile, BundleModel textBundleModel, String type, String message, int severity, String header, String sourceName, String dependency) {
        Diagnostic diagnostic;
        if (textBundleModel != null) {
            ArrayList<Object> data = new ArrayList<Object>(Arrays.asList(IPluginChecker2.markerType(type), IPluginChecker2.lineNumber(this.getLineNumber(textBundleModel.getBundle().getManifestHeader(header)))));
            if (dependency != null) {
                data.add(IPluginChecker2.problem(0xFF1001));
                data.add(IPluginChecker2.missingDependency(dependency));
                data.add(IPluginChecker2.collatedMessageArgument(0, sourceName));
                data.add(IPluginChecker2.messageArgument(1, dependency));
                data.add(IPluginChecker2.missingDependency(dependency));
            }
            diagnostic = this.createDiagnostic(manifestFile, severity, 0, message, data.toArray());
        } else {
            diagnostic = this.createDiagnostic(manifestFile, severity, 0, message, new Object[0]);
        }
        diagnostics.add(diagnostic);
    }

    private BundleModel prepareTextBundleModel(IFile manifestFile) {
        BundleModel bm;
        block5: {
            IDocument doc;
            block4: {
                try {
                    doc = this.createDocument(manifestFile);
                    if (doc != null) break block4;
                    return null;
                }
                catch (CoreException e) {
                    Activator.log.error((Throwable)e);
                    return null;
                }
            }
            bm = new BundleModel(doc, true);
            bm.load();
            if (bm.isLoaded()) break block5;
            return null;
        }
        return bm;
    }

    protected IDocument createDocument(IFile file) {
        if (!file.exists()) {
            return null;
        }
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        if (manager == null) {
            return null;
        }
        IDocument document = null;
        try {
            try {
                manager.connect(file.getFullPath(), LocationKind.NORMALIZE, null);
                ITextFileBuffer textBuf = manager.getTextFileBuffer(file.getFullPath(), LocationKind.NORMALIZE);
                document = textBuf.getDocument();
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
                try {
                    manager.disconnect(file.getFullPath(), LocationKind.NORMALIZE, null);
                }
                catch (CoreException e2) {
                    Activator.log.error((Throwable)e2);
                }
            }
        }
        finally {
            try {
                manager.disconnect(file.getFullPath(), LocationKind.NORMALIZE, null);
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return document;
    }

    private Collection<URI> getExternalReferencesPaths(DiagnosticChain diagnostics, IProject project, IFile modelFile, Resource resource) {
        HashSet<URI> externalReferencesPaths = new HashSet<URI>();
        if (modelFile == null || resource == null) {
            return externalReferencesPaths;
        }
        Set<URI> externalRefs = ModelDependenciesChecker.computeExternalCrossReferences(resource);
        for (URI resourceURI : externalRefs) {
            if (!this.isExternalReferenceToManage(project, resourceURI)) continue;
            if (resourceURI.isFile()) {
                diagnostics.add(this.createDiagnostic(project, modelFile, 4, 1, "Cross-document reference by file URI is not portable: '" + resourceURI.toString() + "'.", new Object[0]));
                continue;
            }
            if (!resourceURI.isPlatform()) {
                URI correspondingURI = resource.getResourceSet().getURIConverter().normalize(resourceURI);
                if (resourceURI.equals(correspondingURI) && !this.isResolved(resourceURI, resource)) {
                    diagnostics.add(this.createDiagnostic(project, modelFile, 4, 1, "The URI '" + resourceURI.toString() + "' cannot be resolved.", new Object[0]));
                    continue;
                }
                externalReferencesPaths.add(correspondingURI);
                continue;
            }
            externalReferencesPaths.add(resourceURI);
        }
        return externalReferencesPaths;
    }

    private boolean isResolved(URI href, Resource context) {
        Resource resolved = context.getResourceSet().getResource(href, false);
        return resolved != null && resolved.isLoaded() && !resolved.getContents().isEmpty();
    }

    static Set<URI> computeExternalCrossReferences(Resource resource) {
        HashSet<URI> result = new HashSet<URI>();
        LinkedList<Resource> work = new LinkedList<Resource>();
        result.add(resource.getURI());
        Resource next = resource;
        while (next != null) {
            Map xrefs = EcoreUtil.ExternalCrossReferencer.find((Resource)resource);
            for (Collection settings : xrefs.values()) {
                for (EStructuralFeature.Setting setting : settings) {
                    if (!(setting.getEStructuralFeature() instanceof EReference)) continue;
                    Object value = setting.get(false);
                    Set<Object> nextToScan = value instanceof Collection ? ((Collection)value).stream().map(EObject.class::cast).map(EcoreUtil::getURI).map(URI::trimFragment).collect(Collectors.toSet()) : Set.of(EcoreUtil.getURI((EObject)((EObject)value)).trimFragment());
                    for (URI uri : nextToScan) {
                        if (uri.isEmpty() || !result.add(uri)) continue;
                        try {
                            work.offer(resource.getResourceSet().getResource(uri, true));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            next = (Resource)work.poll();
        }
        result.remove(resource.getURI());
        return result;
    }

    private boolean isExternalReferenceToManage(IProject project, URI uri) {
        return !uri.isPlatformPlugin() && !uri.isPlatformResource() || uri.segmentCount() < 2 || !uri.segment(1).equals(project.getName());
    }

    private String getPluginNameFromURI(URI uri, DiagnosticChain diagnostics) {
        String pluginName = null;
        if ((uri.isPlatformPlugin() || uri.isPlatformResource()) && uri.segmentCount() > 1) {
            pluginName = uri.segment(1);
        } else if (BUNDLE_CLASS_SCHEME.equals(uri.scheme()) && uri.hasAuthority()) {
            pluginName = uri.authority();
        } else if (BUNDLE_RESOURCE_SCHEME.equals(uri.scheme()) && uri.hasAuthority()) {
            Bundle bundle = null;
            Matcher m = this.bundleResourceAuthorityPattern.matcher(uri.authority());
            if (m.find()) {
                long bundleID = Long.parseLong(m.group());
                bundle = Activator.getDefault().getBundle().getBundleContext().getBundle(bundleID);
            }
            if (bundle != null) {
                pluginName = bundle.getSymbolicName();
            }
        } else {
            EPackage ePackage = this.resource.getResourceSet().getPackageRegistry().getEPackage(uri.toString());
            if (ePackage != null) {
                Bundle bundle = FrameworkUtil.getBundle(ePackage.getClass());
                if (bundle != null) {
                    pluginName = bundle.getSymbolicName();
                }
            } else {
                diagnostics.add(this.createDiagnostic(2, 0, NLS.bind((String)Messages.ModelDependenciesChecker_2, (Object)uri), new Object[0]));
            }
        }
        return pluginName;
    }

    private int getLineNumber(IManifestHeader imh) {
        if (!(imh instanceof ManifestHeader)) {
            return 0;
        }
        ManifestHeader mh = (ManifestHeader)imh;
        IDocument doc = ((BundleModel)mh.getModel()).getDocument();
        try {
            int bundleEntryLineNumber = doc.getLineOfOffset(mh.getOffset()) + 1;
            return bundleEntryLineNumber;
        }
        catch (BadLocationException e) {
            Activator.log.error((Throwable)e);
            return 0;
        }
    }

    public static ToIntFunction<String> warningsFor(String ... bundleSymbolicNames) {
        Set<String> warningExceptions = Set.of(bundleSymbolicNames);
        return bundleName -> warningExceptions.contains(bundleName) ? 2 : 4;
    }

    private static class ManifestError {
        private final String type;
        private final String message;
        private final int severity;
        private final String header;
        private final String dependentName;
        private final String dependencyName;

        ManifestError(String type, String message, int severity, String header, String dependentName, String dependencyName) {
            this.type = type;
            this.message = message;
            this.severity = severity;
            this.header = header;
            this.dependentName = dependentName;
            this.dependencyName = dependencyName;
        }
    }
}

