/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.xpand;

import java.util.HashSet;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.papyrus.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.papyrus.gmf.internal.xpand.model.AmbiguousDefinitionException;
import org.eclipse.papyrus.gmf.internal.xpand.model.AnalysationIssue;
import org.eclipse.papyrus.gmf.internal.xpand.model.EvaluationException;
import org.eclipse.papyrus.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.papyrus.gmf.internal.xpand.model.ExecutionContextImpl;
import org.eclipse.papyrus.gmf.internal.xpand.model.Scope;
import org.eclipse.papyrus.gmf.internal.xpand.model.Variable;
import org.eclipse.papyrus.gmf.internal.xpand.model.XpandDefinition;
import org.eclipse.papyrus.gmf.internal.xpand.model.XpandResource;
import org.eclipse.papyrus.gmf.internal.xpand.ocl.DeclaredParameter;

public class XpandFacade {
    private final Scope scope;
    private ExecutionContext ctx;

    public XpandFacade(Scope scope) {
        assert (scope != null);
        this.scope = scope;
    }

    public XpandFacade(ExecutionContext ctx) {
        this(ctx.getScope());
        this.ctx = ctx;
    }

    public void evaluate(String definitionName, Object targetObject, Object[] params) throws AmbiguousDefinitionException {
        params = params == null ? new Object[]{} : params;
        EClassifier targetType = BuiltinMetaModel.getType(this.getContext(), targetObject);
        EClassifier[] paramTypes = new EClassifier[params.length];
        int i = 0;
        while (i < paramTypes.length) {
            paramTypes[i] = BuiltinMetaModel.getType(this.getContext(), params[i]);
            ++i;
        }
        XpandDefinition def = this.getContext().findDefinition(definitionName, targetType, paramTypes);
        if (def == null) {
            throw new EvaluationException("No Definition " + definitionName + this.getParamString(paramTypes) + " for " + targetType.getName() + " could be found!");
        }
        ExecutionContext ctx = new ExecutionContextImpl(this.scope);
        ctx = ctx.cloneWithResource(def.getOwner());
        ctx = ctx.cloneWithVariable(new Variable("this", def.getTargetType().getTypeForName(ctx), targetObject));
        int i2 = 0;
        while (i2 < params.length) {
            DeclaredParameter declaredParameter = def.getParams()[i2];
            ctx = ctx.cloneWithVariable(new Variable(declaredParameter.getVarName(), declaredParameter.getTypeForName(ctx), params[i2]));
            ++i2;
        }
        def.evaluate(ctx);
    }

    private ExecutionContext getContext() {
        if (this.ctx == null) {
            this.ctx = new ExecutionContextImpl(this.scope);
        }
        return this.ctx;
    }

    private String getParamString(EClassifier[] paramTypes) {
        if (paramTypes.length == 0) {
            return "";
        }
        StringBuilder buff = new StringBuilder("(");
        int i = 0;
        while (i < paramTypes.length) {
            EClassifier t = paramTypes[i];
            buff.append(t.getName());
            if (i + 1 < paramTypes.length) {
                buff.append(",");
            }
            ++i;
        }
        buff.append(")");
        return buff.toString();
    }

    public AnalysationIssue[] analyze(String templateName) {
        HashSet<AnalysationIssue> issues = new HashSet<AnalysationIssue>();
        XpandResource tpl = this.scope.findTemplate(templateName);
        tpl.analyze(new ExecutionContextImpl(this.scope, tpl, null), issues);
        return issues.toArray(new AnalysationIssue[issues.size()]);
    }
}

