/**
 * Copyright (c) 2007, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.editor;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import plugin.Activator;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Externalizer;
import xpt.ExternalizerUtils_qvto;

@Singleton
@SuppressWarnings("all")
public class ElementChooser {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private CodeStyle _codeStyle;
  
  @Inject
  @Extension
  private ExternalizerUtils_qvto _externalizerUtils_qvto;
  
  @Inject
  private Externalizer xptExternalizer;
  
  @Inject
  private Activator xptActivator;
  
  public CharSequence className(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _elementChooserClassName = it.getElementChooserClassName();
    _builder.append(_elementChooserClassName);
    return _builder;
  }
  
  public CharSequence packageName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _packageName = it.getEditorGen().getEditor().getPackageName();
    _builder.append(_packageName);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence extendsList(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("extends org.eclipse.gmf.tooling.runtime.part.DefaultElementChooserDialog");
    return _builder;
  }
  
  public CharSequence ElementChooser(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" ");
    CharSequence _extendsList = this.extendsList(it);
    _builder.append(_extendsList);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _constructors = this.constructors(it);
    _builder.append(_constructors, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _context = this.context(it);
    _builder.append(_context, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence constructors(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append("(org.eclipse.swt.widgets.Shell parentShell, org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("this(parentShell, view, false);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    CharSequence _className_1 = this.className(it);
    _builder.append(_className_1);
    _builder.append("(org.eclipse.swt.widgets.Shell parentShell, org.eclipse.gmf.runtime.notation.View view, boolean allowMultiSelection) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("super(parentShell, view, new ");
    CharSequence _contextClassName = this.contextClassName(it);
    _builder.append(_contextClassName, "\t");
    _builder.append("(allowMultiSelection));");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence contextClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append("ContextImpl");
    return _builder;
  }
  
  public CharSequence context(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private static class ");
    CharSequence _contextClassName = this.contextClassName(it);
    _builder.append(_contextClassName);
    _builder.append(" implements org.eclipse.gmf.tooling.runtime.part.DefaultElementChooserDialog.Context {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _context_attributes = this.context_attributes(it);
    _builder.append(_context_attributes, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _context_constructors = this.context_constructors(it);
    _builder.append(_context_constructors, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _itemProvidersAdapterFactory = this.getItemProvidersAdapterFactory(it);
    _builder.append(_itemProvidersAdapterFactory, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _diagramPreferencesHint = this.getDiagramPreferencesHint(it);
    _builder.append(_diagramPreferencesHint, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _fileExtensions = this.getFileExtensions(it);
    _builder.append(_fileExtensions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _dialogTitle = this.getDialogTitle(it);
    _builder.append(_dialogTitle, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _treeContentProvider = this.getTreeContentProvider(it);
    _builder.append(_treeContentProvider, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _allowMultiSelection = this.allowMultiSelection(it);
    _builder.append(_allowMultiSelection, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _context_additions = this.context_additions(it);
    _builder.append(_context_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence context_attributes(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private static final String[] FILE_EXTENSIONS = new String[]{");
    _builder.newLine();
    _builder.append("\t");
    {
      EList<String> _containsShortcutsTo = it.getContainsShortcutsTo();
      boolean _hasElements = false;
      for(final String ext : _containsShortcutsTo) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(", ", "\t");
        }
        _builder.append("\"");
        _builder.append(ext, "\t");
        _builder.append("\"");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    _builder.append("private final boolean myAllowMultiSelection;");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence context_constructors(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private ");
    CharSequence _contextClassName = this.contextClassName(it);
    _builder.append(_contextClassName);
    _builder.append("(boolean allowMultiSelection) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("myAllowMultiSelection = allowMultiSelection;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getItemProvidersAdapterFactory(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideI = this._codeStyle.overrideI(it);
    _builder.append(_overrideI);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.emf.common.notify.AdapterFactory getAdapterFactory() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return ");
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName, "\t");
    _builder.append(".getInstance().getItemProvidersAdapterFactory();");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getDiagramPreferencesHint(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideI = this._codeStyle.overrideI(it);
    _builder.append(_overrideI);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint getPreferenceHint() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return ");
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName, "\t");
    _builder.append(".DIAGRAM_PREFERENCES_HINT;");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getFileExtensions(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideI = this._codeStyle.overrideI(it);
    _builder.append(_overrideI);
    _builder.newLineIfNotEmpty();
    _builder.append("public String[] getFileExtesions() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return FILE_EXTENSIONS.clone();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getDialogTitle(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideI = this._codeStyle.overrideI(it);
    _builder.append(_overrideI);
    _builder.newLineIfNotEmpty();
    _builder.append("public String getDialogTitle() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return ");
    CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getEditorGen(), this._externalizerUtils_qvto.titleKey(this.i18nKeyForSelectModelElement(it)));
    _builder.append(_accessorCall, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getTreeContentProvider(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideI = this._codeStyle.overrideI(it);
    _builder.append(_overrideI);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.jface.viewers.ITreeContentProvider getTreeContentProvider() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return new ");
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _notEquals = (!Objects.equal(_application, null));
      if (_notEquals) {
        _builder.append("new org.eclipse.ui.model.WorkbenchContentProvider");
      } else {
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("org.eclipse.ui.model.BaseWorkbenchContentProvider");
      }
    }
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence allowMultiSelection(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public boolean allowMultiSelection() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return myAllowMultiSelection;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence context_additions(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public CharSequence additions(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  @Localization
  public CharSequence i18nValues(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _messageEntry = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.titleKey(this.i18nKeyForSelectModelElement(it)), "Select model element");
    _builder.append(_messageEntry);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  @Localization
  public CharSequence i18nAccessors(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _accessorField = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.titleKey(this.i18nKeyForSelectModelElement(it)));
    _builder.append(_accessorField);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  @Localization
  public String i18nKeyForSelectModelElement(final GenDiagram diagram) {
    String _i18nKeyForElementChooser = this.i18nKeyForElementChooser(diagram);
    return (_i18nKeyForElementChooser + ".SelectModelElement");
  }
  
  @Localization
  public String i18nKeyForElementChooser(final GenDiagram diagram) {
    CharSequence _className = this.className(diagram);
    return ("" + _className);
  }
}
