/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.diagram.editparts;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import impl.diagram.editparts.TextAware;
import impl.diagram.editparts.viewmaps.modeledViewmapProducer;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Behaviour;
import org.eclipse.papyrus.gmf.codegen.gmfgen.CustomBehaviour;
import org.eclipse.papyrus.gmf.codegen.gmfgen.FigureViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenContainerBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.InnerClassViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ModeledViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.OpenDiagramBehaviour;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ParentAssignedViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.SnippetViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.papyrus.gmf.gmfgraph.DiagramLabel;
import org.eclipse.papyrus.gmf.gmfgraph.Figure;
import org.eclipse.papyrus.gmf.gmfgraph.Label;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common_qvto;
import xpt.editor.VisualIDRegistry;

@Singleton
@SuppressWarnings("all")
public class Common {
  @Inject
  @Extension
  private xpt.Common _common;
  
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  @Inject
  private TextAware xptTextAware;
  
  @Inject
  private modeledViewmapProducer xptModeledViewmapProducer;
  
  @Inject
  private VisualIDRegistry xptVisualIDRegistry;
  
  public CharSequence visualIDConstant(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static final int VISUAL_ID = ");
    int _visualID = it.getVisualID();
    _builder.append(_visualID);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence behaviour(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<Behaviour> _behaviour = it.getBehaviour();
      for(final Behaviour b : _behaviour) {
        CharSequence _dispatchBehaviour = this.dispatchBehaviour(b);
        _builder.append(_dispatchBehaviour);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  protected CharSequence _dispatchBehaviour(final Behaviour it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  protected CharSequence _dispatchBehaviour(final CustomBehaviour it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _nullOrSpaces = this._common_qvto.nullOrSpaces(it.getEditPolicyQualifiedClassName());
      if (_nullOrSpaces) {
        _builder.append("removeEditPolicy(");
        String _key = it.getKey();
        _builder.append(_key);
        _builder.append("); ");
        {
          if ((it.getKey().startsWith("\"") && it.getKey().endsWith("\""))) {
            CharSequence _nonNLS = this._common.nonNLS(1);
            _builder.append(_nonNLS);
          }
        }
        _builder.newLineIfNotEmpty();
      } else {
        _builder.append("installEditPolicy(");
        String _key_1 = it.getKey();
        _builder.append(_key_1);
        _builder.append(", new ");
        String _editPolicyQualifiedClassName = it.getEditPolicyQualifiedClassName();
        _builder.append(_editPolicyQualifiedClassName);
        _builder.append("()); ");
        {
          if ((it.getKey().startsWith("\"") && it.getKey().endsWith("\""))) {
            CharSequence _nonNLS_1 = this._common.nonNLS(1);
            _builder.append(_nonNLS_1);
          }
        }
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  protected CharSequence _dispatchBehaviour(final OpenDiagramBehaviour it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("installEditPolicy(org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles.OPEN_ROLE,");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("new ");
    String _editPolicyQualifiedClassName = it.getEditPolicyQualifiedClassName();
    _builder.append(_editPolicyQualifiedClassName, "\t");
    _builder.append("());");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _labelFigure(final ParentAssignedViewmap it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.draw2d.IFigure createFigure() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// Parent should assign one using ");
    CharSequence _labelSetterName = this.xptTextAware.labelSetterName(it);
    _builder.append(_labelSetterName, "\t");
    _builder.append("() method");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _labelFigure(final ModeledViewmap it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if ((this._common_qvto.oclIsKindOf(it.getFigureModel(), DiagramLabel.class) && (!Objects.equal(((DiagramLabel) it.getFigureModel()).getAccessor(), null)))) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("protected org.eclipse.draw2d.IFigure createFigure() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// Parent should assign one using ");
        CharSequence _labelSetterName = this.xptTextAware.labelSetterName(it);
        _builder.append(_labelSetterName, "\t");
        _builder.append("() method");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      } else {
        CharSequence _labelFigureDelegateToPrim = this.labelFigureDelegateToPrim(it);
        _builder.append(_labelFigureDelegateToPrim);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  protected CharSequence _labelFigure(final Viewmap it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _labelFigureDelegateToPrim = this.labelFigureDelegateToPrim(it);
    _builder.append(_labelFigureDelegateToPrim);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence labelFigureDelegateToPrim(final Viewmap it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected org.eclipse.draw2d.IFigure createFigure() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.draw2d.IFigure label = createFigurePrim();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("defaultText = getLabelTextHelper(label);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return label;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected org.eclipse.draw2d.IFigure createFigurePrim() {");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _labelFigurePrim = this.labelFigurePrim(it);
    _builder.append(_labelFigurePrim, "\t\t");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _labelFigurePrim(final FigureViewmap it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      String _figureQualifiedClassName = it.getFigureQualifiedClassName();
      boolean _equals = Objects.equal(_figureQualifiedClassName, null);
      if (_equals) {
        _builder.append("return new org.eclipse.draw2d.Label();");
        _builder.newLine();
      } else {
        _builder.append("return new ");
        String _figureQualifiedClassName_1 = it.getFigureQualifiedClassName();
        _builder.append(_figureQualifiedClassName_1);
        _builder.append("();");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _labelFigurePrim(final SnippetViewmap it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("return ");
    String _body = it.getBody();
    _builder.append(_body);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _labelFigurePrim(final InnerClassViewmap it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("return new ");
    String _className = it.getClassName();
    _builder.append(_className);
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    String _classBody = it.getClassBody();
    _builder.append(_classBody);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _labelFigurePrim(final ModeledViewmap it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("return new ");
    CharSequence _viewmapFigureFQN = this.xptModeledViewmapProducer.viewmapFigureFQN(it);
    _builder.append(_viewmapFigureFQN);
    _builder.append("(");
    CharSequence _labelTextDefaultValue = this.labelTextDefaultValue(it.getFigureModel());
    _builder.append(_labelTextDefaultValue);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _labelTextDefaultValue(final EObject it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  protected CharSequence _labelTextDefaultValue(final DiagramLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if ((((!Objects.equal(it.getFigure(), null)) && this._common_qvto.oclIsKindOf(it.getFigure().getActualFigure(), Label.class)) && (!Objects.equal(((Label) it.getFigure().getActualFigure()).getText(), null)))) {
        _builder.append("\"");
        Figure _actualFigure = it.getFigure().getActualFigure();
        String _text = ((Label) _actualFigure).getText();
        _builder.append(_text);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  protected CharSequence _labelFigurePrim(final Viewmap it) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("Unknown viewmap: " + it));
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence notationalListeners(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected void addNotationalListeners() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("super.addNotationalListeners();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("addListenerFilter(\"PrimaryView\", this, getPrimaryView()); ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected void removeNotationalListeners() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("super.removeNotationalListeners();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("removeListenerFilter(\"PrimaryView\"); ");
    CharSequence _nonNLS_1 = this._common.nonNLS(1);
    _builder.append(_nonNLS_1, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence handleBounds(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getSize_Width().equals(feature) ||");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getSize_Height().equals(feature) ||");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getLocation_X().equals(feature) ||");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getLocation_Y().equals(feature)) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("refreshBounds();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence handleText(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getFontStyle_FontColor().equals(feature)) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("Integer c = (Integer) event.getNewValue();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("setFontColor(org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry.getInstance().getColor(c));");
    _builder.newLine();
    _builder.append("} else if (org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getFontStyle_Underline().equals(feature)) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("refreshUnderline();");
    _builder.newLine();
    _builder.append("} else if (org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getFontStyle_StrikeThrough().equals(feature)) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("refreshStrikeThrough();");
    _builder.newLine();
    _builder.append("} else if (org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getFontStyle_FontHeight().equals(feature) ||");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getFontStyle_FontName().equals(feature) ||");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getFontStyle_Bold().equals(feature) ||");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getFontStyle_Italic().equals(feature)) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("refreshFont();");
    _builder.newLine();
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (getParser() != null && getParser().isAffectingEvent(event, getParserOptions().intValue())) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("refreshLabel();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (getParser() instanceof org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser modelParser =");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("(org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser) getParser();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (modelParser.areSemanticElementsAffected(null, event)) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("removeSemanticListeners();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (resolveSemanticElement() != null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("addSemanticListeners();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("refreshLabel();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence installSemanticEditPolicy(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isSansDomain = it.isSansDomain();
      if (_isSansDomain) {
        _builder.append("removeEditPolicy(org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles.SEMANTIC_ROLE);");
        _builder.newLine();
      } else {
        _builder.append("installEditPolicy(org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles.SEMANTIC_ROLE, new ");
        String _itemSemanticEditPolicyQualifiedClassName = it.getItemSemanticEditPolicyQualifiedClassName();
        _builder.append(_itemSemanticEditPolicyQualifiedClassName);
        _builder.append("());");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence installCanonicalEditPolicy(final GenContainerBase it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _needsCanonicalEditPolicy = it.needsCanonicalEditPolicy();
      if (_needsCanonicalEditPolicy) {
        _builder.append("installEditPolicy(org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles.CANONICAL_ROLE, new ");
        String _canonicalEditPolicyQualifiedClassName = it.getCanonicalEditPolicyQualifiedClassName();
        _builder.append(_canonicalEditPolicyQualifiedClassName);
        _builder.append("());");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence installCreationEditPolicy(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("installEditPolicy(org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles.CREATION_ROLE, ");
    CharSequence _creationEditPolicyNewInstance = this.creationEditPolicyNewInstance(it);
    _builder.append(_creationEditPolicyNewInstance);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence creationEditPolicyNewInstance(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("new org.eclipse.gmf.tooling.runtime.edit.policies.reparent.CreationEditPolicyWithCustomReparent(");
    CharSequence _runtimeTypedInstanceCall = this.xptVisualIDRegistry.runtimeTypedInstanceCall(it.getDiagram());
    _builder.append(_runtimeTypedInstanceCall);
    _builder.append(")");
    return _builder;
  }
  
  public CharSequence dispatchBehaviour(final Behaviour it) {
    if (it instanceof CustomBehaviour) {
      return _dispatchBehaviour((CustomBehaviour)it);
    } else if (it instanceof OpenDiagramBehaviour) {
      return _dispatchBehaviour((OpenDiagramBehaviour)it);
    } else if (it != null) {
      return _dispatchBehaviour(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
  
  public CharSequence labelFigure(final Viewmap it) {
    if (it instanceof ModeledViewmap) {
      return _labelFigure((ModeledViewmap)it);
    } else if (it instanceof ParentAssignedViewmap) {
      return _labelFigure((ParentAssignedViewmap)it);
    } else if (it != null) {
      return _labelFigure(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
  
  public CharSequence labelFigurePrim(final Viewmap it) {
    if (it instanceof FigureViewmap) {
      return _labelFigurePrim((FigureViewmap)it);
    } else if (it instanceof InnerClassViewmap) {
      return _labelFigurePrim((InnerClassViewmap)it);
    } else if (it instanceof ModeledViewmap) {
      return _labelFigurePrim((ModeledViewmap)it);
    } else if (it instanceof SnippetViewmap) {
      return _labelFigurePrim((SnippetViewmap)it);
    } else if (it != null) {
      return _labelFigurePrim(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
  
  public CharSequence labelTextDefaultValue(final EObject it) {
    if (it instanceof DiagramLabel) {
      return _labelTextDefaultValue((DiagramLabel)it);
    } else if (it != null) {
      return _labelTextDefaultValue(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
}
