/**
 * Copyright (c) 2014, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Svyatoslav Kovalsky (Montages) - initial API and implementation
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.xtend2.lib.StringConcatenation;

@Singleton
@SuppressWarnings("all")
public class Values {
  @Inject
  private Externalizer ext;
  
  public CharSequence qualifiedClassName(final GenEditorGenerator it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("messages.properties");
    return _builder;
  }
  
  public CharSequence fullPath(final GenEditorGenerator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence Values(final GenEditorGenerator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _Values = this.ext.Values(it);
    _builder.append(_Values);
    return _builder;
  }
}
