/**
 * ﻿ * Copyright (c) 2011 Montages AG
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Artem Tikhomirov (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package impl.diagram.editparts.viewmaps;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.gmf.gmfgraph.FigureDescriptor;
import org.eclipse.papyrus.gmf.gmfgraph.RealFigure;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import xpt.Common_qvto;

@Singleton
@SuppressWarnings("all")
public class BareFigure_qvto {
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  public boolean isBareFigureDescriptor(final FigureDescriptor descriptor) {
    return (this._common_qvto.oclIsKindOf(descriptor.getActualFigure(), RealFigure.class) && 
      this.isBareFigure(((RealFigure) descriptor.getActualFigure())));
  }
  
  private boolean isDerivedOrAlwaysSet(final EStructuralFeature f) {
    return ((((f.isDerived() || (Objects.equal(f.getEContainingClass().getName(), "RealFigure") && Objects.equal(f.getName(), "name"))) || (Objects.equal(f.getEContainingClass().getName(), "RealFigure") && Objects.equal(f.getName(), "children"))) || (Objects.equal(f.getEContainingClass().getName(), "CustomClass") && Objects.equal(f.getName(), "qualifiedClassName"))) || (Objects.equal(f.getEContainingClass().getName(), "CustomFigure") && Objects.equal(f.getName(), "customChildren")));
  }
  
  public boolean isBareFigure(final RealFigure figure) {
    boolean _xblockexpression = false;
    {
      final Function1<EStructuralFeature, Boolean> _function = new Function1<EStructuralFeature, Boolean>() {
        @Override
        public Boolean apply(final EStructuralFeature f) {
          boolean _isDerivedOrAlwaysSet = BareFigure_qvto.this.isDerivedOrAlwaysSet(f);
          return Boolean.valueOf((!_isDerivedOrAlwaysSet));
        }
      };
      Iterable<EStructuralFeature> featuresToCheck = IterableExtensions.<EStructuralFeature>filter(figure.eClass().getEAllStructuralFeatures(), _function);
      _xblockexpression = (figure.getChildren().isEmpty() && IterableExtensions.<EStructuralFeature>forall(featuresToCheck, new Function1<EStructuralFeature, Boolean>() {
        @Override
        public Boolean apply(final EStructuralFeature f) {
          boolean _eIsSet = figure.eIsSet(f);
          return Boolean.valueOf((!_eIsSet));
        }
      }));
    }
    return _xblockexpression;
  }
}
