/**
 * Copyright (c) 2014 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Florian Noyrit - Initial API and implementation
 */
package utils;

import com.google.common.collect.Iterators;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.papyrusgmfgenextension.AdditionalEditPartCandies;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

@Singleton
@SuppressWarnings("all")
public class EditHelperUtils_qvto {
  public String getBaseEditHelperFullName(final GenDiagram diagram) {
    boolean _isEmpty = IteratorExtensions.isEmpty(Iterators.<AdditionalEditPartCandies>filter(diagram.eResource().getAllContents(), AdditionalEditPartCandies.class));
    boolean _not = (!_isEmpty);
    if (_not) {
      String _baseEditHelperPackage = IteratorExtensions.<AdditionalEditPartCandies>head(Iterators.<AdditionalEditPartCandies>filter(diagram.eResource().getAllContents(), AdditionalEditPartCandies.class)).getBaseEditHelperPackage();
      String _plus = (_baseEditHelperPackage + ".");
      String _baseEditHelperClassName = diagram.getBaseEditHelperClassName();
      return (_plus + _baseEditHelperClassName);
    } else {
      return diagram.getBaseEditHelperQualifiedClassName();
    }
  }
}
