/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.p2.impl;

import java.io.OutputStream;
import java.util.Iterator;
import org.eclipse.cbi.p2repo.p2.ArtifactRepository;
import org.eclipse.cbi.p2repo.p2.P2Factory;
import org.eclipse.cbi.p2repo.p2.P2Package;
import org.eclipse.cbi.p2repo.p2.impl.ArtifactDescriptorImpl;
import org.eclipse.cbi.p2repo.p2.impl.ArtifactKeyImpl;
import org.eclipse.cbi.p2repo.p2.impl.ArtifactsByKeyImpl;
import org.eclipse.cbi.p2repo.p2.impl.RepositoryImpl;
import org.eclipse.cbi.p2repo.p2.util.P2Bridge;
import org.eclipse.cbi.p2repo.util.MonitorUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.equinox.internal.p2.metadata.expression.CompoundIterator;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.IRunnableWithProgress;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;

public class ArtifactRepositoryImpl
extends RepositoryImpl<IArtifactKey>
implements ArtifactRepository {
    protected EMap<IArtifactKey, EList<IArtifactDescriptor>> artifactMap;
    private static final IArtifactDescriptor[] noDescriptors = new IArtifactDescriptor[0];

    protected ArtifactRepositoryImpl() {
    }

    public void addDescriptor(IArtifactDescriptor descriptor) {
        if (!(descriptor instanceof ArtifactDescriptorImpl)) {
            descriptor = P2Bridge.importToModel(this, descriptor);
        }
        IArtifactKey key = descriptor.getArtifactKey();
        EMap<IArtifactKey, EList<IArtifactDescriptor>> map = this.getArtifactMap();
        EList descs = (EList)map.get((Object)key);
        if (descs == null) {
            descs = new BasicEList();
            descs.add((Object)descriptor);
            map.put((Object)key, (Object)descs);
        } else {
            descs.add((Object)descriptor);
        }
    }

    public void addDescriptor(IArtifactDescriptor descriptor, IProgressMonitor monitor) {
        this.addDescriptor(descriptor);
        MonitorUtils.complete((IProgressMonitor)monitor);
    }

    public void addDescriptors(IArtifactDescriptor[] descriptors) {
        IArtifactDescriptor[] iArtifactDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactDescriptor descriptor = iArtifactDescriptorArray[n2];
            this.addDescriptor(descriptor);
            ++n2;
        }
    }

    public void addDescriptors(IArtifactDescriptor[] descriptors, IProgressMonitor monitor) {
        this.addDescriptors(descriptors);
        MonitorUtils.complete((IProgressMonitor)monitor);
    }

    public boolean contains(IArtifactDescriptor descriptor) {
        EList descs = (EList)this.getArtifactMap().get((Object)descriptor.getArtifactKey());
        if (descs == null) {
            return false;
        }
        if (!(descriptor instanceof ArtifactDescriptorImpl)) {
            descriptor = P2Bridge.importToModel(this, descriptor);
        }
        for (IArtifactDescriptor ad : descs) {
            if (!ad.equals(descriptor)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(IArtifactKey key) {
        return this.getArtifactMap().containsKey((Object)key);
    }

    public IArtifactDescriptor createArtifactDescriptor(IArtifactKey key) {
        ArtifactDescriptorImpl desc = (ArtifactDescriptorImpl)P2Factory.eINSTANCE.createArtifactDescriptor();
        if (!(key instanceof ArtifactKeyImpl)) {
            key = P2Bridge.importToModel(key);
        }
        desc.setArtifactKey(key);
        return desc;
    }

    public IArtifactKey createArtifactKey(String classifier, String id, Version version) {
        ArtifactKeyImpl key = (ArtifactKeyImpl)P2Factory.eINSTANCE.createArtifactKey();
        key.setClassifier(classifier);
        key.setId(id);
        key.setVersion(version);
        return key;
    }

    public IQueryable<IArtifactDescriptor> descriptorQueryable() {
        return new IQueryable<IArtifactDescriptor>(){

            public IQueryResult<IArtifactDescriptor> query(IQuery<IArtifactDescriptor> query, IProgressMonitor monitor) {
                return query.perform((Iterator)new CompoundIterator(ArtifactRepositoryImpl.this.getArtifactMap().values().iterator()));
            }
        };
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 9: {
                if (coreType) {
                    return this.getArtifactMap();
                }
                return this.getArtifactMap().map();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 9: {
                return ((InternalEList)this.getArtifactMap()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return this.artifactMap != null && !this.artifactMap.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 9: {
                ((EStructuralFeature.Setting)this.getArtifactMap()).set(newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    protected EClass eStaticClass() {
        return P2Package.Literals.ARTIFACT_REPOSITORY;
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 9: {
                this.getArtifactMap().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus executeBatch(IRunnableWithProgress runnable, IProgressMonitor monitor) {
        IStatus result;
        ArtifactRepositoryImpl artifactRepositoryImpl = this;
        synchronized (artifactRepositoryImpl) {
            try {
                runnable.run(monitor);
                result = Status.OK_STATUS;
            }
            catch (OperationCanceledException e) {
                result = new Status(8, "org.eclipse.cbi.p2repo.p2", e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                result = new Status(4, "org.eclipse.cbi.p2repo.p2", e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public IStatus getArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public IArtifactDescriptor[] getArtifactDescriptors(IArtifactKey key) {
        EList result = (EList)this.getArtifactMap().get((Object)key);
        return result == null ? noDescriptors : (IArtifactDescriptor[])result.toArray((Object[])new IArtifactDescriptor[result.size()]);
    }

    @Override
    public EMap<IArtifactKey, EList<IArtifactDescriptor>> getArtifactMap() {
        if (this.artifactMap == null) {
            this.artifactMap = new EcoreEMap(P2Package.Literals.ARTIFACTS_BY_KEY, ArtifactsByKeyImpl.class, (InternalEObject)this, 9);
        }
        return this.artifactMap;
    }

    public IStatus getArtifacts(IArtifactRequest[] requests, IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public OutputStream getOutputStream(IArtifactDescriptor descriptor) {
        throw new UnsupportedOperationException();
    }

    public IStatus getRawArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IQueryResult<IArtifactKey> query(IQuery<IArtifactKey> query, IProgressMonitor progress) {
        return query.perform(this.getArtifactMap().keySet().iterator());
    }

    public void removeAll() {
        this.getArtifactMap().clear();
    }

    public void removeAll(IProgressMonitor monitor) {
        this.removeAll();
        MonitorUtils.complete((IProgressMonitor)monitor);
    }

    public void removeDescriptor(IArtifactDescriptor descriptor) {
        int idx;
        IArtifactKey key = descriptor.getArtifactKey();
        EList descs = (EList)this.getArtifactMap().get((Object)key);
        if (descs == null) {
            return;
        }
        if (!(descriptor instanceof ArtifactDescriptorImpl)) {
            descriptor = P2Bridge.importToModel(this, descriptor);
        }
        if ((idx = descs.indexOf((Object)descriptor)) < 0) {
            return;
        }
        descs.remove(idx);
        if (descs.isEmpty()) {
            this.getArtifactMap().removeKey((Object)key);
        }
    }

    public void removeDescriptor(IArtifactDescriptor descriptor, IProgressMonitor monitor) {
        this.removeDescriptor(descriptor);
        MonitorUtils.complete((IProgressMonitor)monitor);
    }

    public void removeDescriptor(IArtifactKey key) {
        this.getArtifactMap().removeKey((Object)key);
    }

    public void removeDescriptor(IArtifactKey key, IProgressMonitor monitor) {
        this.removeDescriptor(key);
        MonitorUtils.complete((IProgressMonitor)monitor);
    }

    public void removeDescriptors(IArtifactDescriptor[] descriptors) {
        IArtifactDescriptor[] iArtifactDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactDescriptor descriptor = iArtifactDescriptorArray[n2];
            this.removeDescriptor(descriptor);
            ++n2;
        }
    }

    public void removeDescriptors(IArtifactDescriptor[] descriptors, IProgressMonitor monitor) {
        this.removeDescriptors(descriptors);
        MonitorUtils.complete((IProgressMonitor)monitor);
    }

    public void removeDescriptors(IArtifactKey[] keys) {
        IArtifactKey[] iArtifactKeyArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactKey key = iArtifactKeyArray[n2];
            this.removeDescriptor(key);
            ++n2;
        }
    }

    public void removeDescriptors(IArtifactKey[] keys, IProgressMonitor monitor) {
        this.removeDescriptors(keys);
        MonitorUtils.complete((IProgressMonitor)monitor);
    }
}

