/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.custom.locators;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.papyrus.uml.diagram.common.editparts.RoundedBorderNamedElementEditPart;
import org.eclipse.papyrus.uml.diagram.common.locator.PortPositionLocator;

public class CustomPortPositionLocator
extends PortPositionLocator {
    protected RoundedBorderNamedElementEditPart portEditPart = null;

    public CustomPortPositionLocator(IFigure parentFigure, RoundedBorderNamedElementEditPart childEditPart) {
        super(parentFigure);
        this.portEditPart = childEditPart;
    }

    @Deprecated
    public CustomPortPositionLocator(IFigure parentFigure, RoundedBorderNamedElementEditPart childEditPart, int none) {
        super(parentFigure, none);
        this.portEditPart = childEditPart;
    }

    public final Rectangle getPreferredLocation(Rectangle proposedLocation) {
        Rectangle realLocation = new Rectangle(proposedLocation);
        Rectangle parentRec = this.getParentFigure().getBounds().getCopy();
        Rectangle thisRec = this.portEditPart.getFigure().getBounds().getCopy();
        int xMin = parentRec.x - thisRec.width / 2;
        int xMax = parentRec.x + parentRec.width - thisRec.width / 2;
        int yMin = parentRec.y - thisRec.height / 2;
        int yMax = parentRec.y + parentRec.height - thisRec.height / 2;
        if (realLocation.x < xMin) {
            realLocation.x = xMin;
        }
        if (realLocation.x > xMax) {
            realLocation.x = xMax;
        }
        if (realLocation.y < yMin) {
            realLocation.y = yMin;
        }
        if (realLocation.y > yMax) {
            realLocation.y = yMax;
        }
        Rectangle maxRect = parentRec.getCopy();
        maxRect.shrink(-this.borderItemOffset, -this.borderItemOffset);
        while (maxRect.contains(realLocation.getLocation())) {
            maxRect.shrink(1, 1);
        }
        int pos = maxRect.getPosition(realLocation.getLocation());
        switch (pos) {
            case 1: {
                realLocation.y = yMin;
                break;
            }
            case 4: {
                realLocation.y = yMax;
                break;
            }
            case 16: {
                realLocation.x = xMax;
                break;
            }
            case 8: {
                realLocation.x = xMin;
                break;
            }
            case 17: {
                realLocation.x = xMax;
                realLocation.y = yMin;
                break;
            }
            case 9: {
                realLocation.x = xMin;
                realLocation.y = yMin;
                break;
            }
            case 20: {
                realLocation.x = xMax;
                realLocation.y = yMax;
                break;
            }
            case 12: {
                realLocation.x = xMin;
                realLocation.y = yMax;
            }
        }
        return realLocation;
    }

    public int getCurrentSideOfParent() {
        int position = 0;
        Rectangle thisRec = this.portEditPart.getFigure().getBounds().getCopy();
        int x = this.constraint.x;
        int y = this.constraint.y;
        Rectangle p = this.parentFigure.getBounds();
        int xMin = p.x - thisRec.width / 2;
        int xMax = p.x + p.width - thisRec.width / 2;
        int yMin = p.y - thisRec.height / 2;
        int yMax = p.y + p.height - thisRec.height / 2;
        position = x == xMin && y == yMin ? 9 : (x == xMin && y == yMax ? 12 : (x == xMax && y == yMin ? 17 : (x == xMax && y == yMax ? 20 : (y == yMin ? 1 : (y == yMax ? 4 : (x == xMin ? 8 : 16))))));
        return position;
    }
}

