/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.nattable.wizard;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.eclipse.project.editors.file.BuildEditor;
import org.eclipse.papyrus.eclipse.project.editors.file.ManifestEditor;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.TableConfiguration;
import org.eclipse.papyrus.infra.nattable.provider.TableStructuredSelection;
import org.eclipse.papyrus.toolsmiths.nattable.Activator;
import org.eclipse.papyrus.toolsmiths.nattable.messages.Messages;
import org.eclipse.papyrus.toolsmiths.nattable.utils.TableChecker;
import org.eclipse.papyrus.toolsmiths.nattable.utils.TableConfigurationUtils;
import org.eclipse.papyrus.toolsmiths.nattable.utils.TableToTableConfigurationConverter;
import org.eclipse.papyrus.toolsmiths.nattable.wizard.pages.DefineOutputPluginWizardPage;
import org.eclipse.papyrus.toolsmiths.nattable.wizard.pages.DefineTableConfigurationDataWizardPage;
import org.eclipse.papyrus.toolsmiths.nattable.wizard.pages.WarningOnCurrentTableWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class ExportAsTableConfigurationWizard
extends Wizard
implements IExportWizard {
    private static final String ICON_FOLDER_PATH = "icons";
    private static final String GIF_FILE_EXTENSION = ".gif";
    private static final String PNG_FILE_EXTENSION = ".png";
    private static final String DEFAULT_TABLE_ICON = "icons/table.png";
    private static final String PLUGIN_XML_FILE = "plugin.xml";
    private static final String SLASH = "/";
    private DefineOutputPluginWizardPage outputPage;
    private DefineTableConfigurationDataWizardPage tableDataPage;
    private Table exportedTable;

    public ExportAsTableConfigurationWizard() {
        this.setWindowTitle(Messages.ExportAsTableConfigurationWizard_WizardTitle);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        TableStructuredSelection tss;
        INattableModelManager tableModelManager;
        if (selection.getFirstElement() instanceof Table) {
            this.exportedTable = (Table)selection.getFirstElement();
        } else if (selection instanceof TableStructuredSelection && (tableModelManager = (INattableModelManager)(tss = (TableStructuredSelection)selection).getAdapter(INattableModelManager.class)) != null) {
            this.exportedTable = tableModelManager.getTable();
        }
        Assert.isNotNull((Object)this.exportedTable, (String)Messages.ExportAsTableConfigurationWizard_WeCantFoundTheTableToExport);
        IStatus status = TableChecker.checkTable(this.exportedTable);
        if (!status.isOK()) {
            this.addPage((IWizardPage)new WarningOnCurrentTableWizardPage(status));
        }
        this.outputPage = new DefineOutputPluginWizardPage();
        this.tableDataPage = new DefineTableConfigurationDataWizardPage();
        this.outputPage.setExportedTable(this.exportedTable);
        this.tableDataPage.setExportedTable(this.exportedTable);
        this.addPage((IWizardPage)this.outputPage);
        this.addPage((IWizardPage)this.tableDataPage);
    }

    public boolean performFinish() {
        String newTableDescription;
        String newTableType;
        String newTableName;
        String fileName;
        String outputFolderName;
        IJavaProject outputJavaProject = this.outputPage.getOutputJavaProject();
        IStatus status = this.createAndRegisterTableConfiguration(outputJavaProject, outputFolderName = this.outputPage.getExportFolderName(), fileName = this.tableDataPage.getFileName(), newTableName = this.tableDataPage.getNewTableDefaultName(), newTableType = this.tableDataPage.getNewTableType(), newTableDescription = this.tableDataPage.getNewTableConfigurationDescription(), this.exportedTable);
        if (!status.isOK()) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ExportAsTableConfigurationWizard_ErrorDuringTableConfigurationCreation, (String)status.getMessage());
        }
        try {
            outputJavaProject.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
        return true;
    }

    public boolean canFinish() {
        return this.outputPage.isPageComplete() && this.tableDataPage.isPageComplete();
    }

    private static final IStatus createErrorStatus(String message) {
        return new Status(4, "org.eclipse.papyrus.toolsmiths.nattable", message);
    }

    private IStatus createAndRegisterTableConfiguration(IJavaProject outputJavaProject, String outputFolderName, String outputFileName, String newTableName, String newTableType, String newTableDescription, Table tableToConvert) {
        String newIconPath;
        IFolder folderIcon;
        IFolder folder = outputJavaProject.getProject().getFolder(outputFolderName);
        if (!folder.exists()) {
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
                return ExportAsTableConfigurationWizard.createErrorStatus(NLS.bind((String)Messages.ExportAsTableConfigurationWizard_OutputFolderCantBeCreateed, (Object)folder, (Object)outputJavaProject.getProject().getName()));
            }
        }
        if (!(folderIcon = outputJavaProject.getProject().getFolder(ICON_FOLDER_PATH)).exists()) {
            try {
                folderIcon.create(true, true, null);
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
                return ExportAsTableConfigurationWizard.createErrorStatus(NLS.bind((String)Messages.ExportAsTableConfigurationWizard_IconFolderCantBeCreated, (Object)folderIcon.getName(), (Object)outputJavaProject.getProject().getName()));
            }
        }
        IFile imageFileGIF = folderIcon.getFile(String.valueOf(newTableType) + GIF_FILE_EXTENSION);
        IFile imageFilePNG = folderIcon.getFile(String.valueOf(newTableType) + PNG_FILE_EXTENSION);
        if (imageFileGIF.exists()) {
            newIconPath = URI.createPlatformPluginURI((String)imageFileGIF.getFullPath().toPortableString(), (boolean)true).toString();
        } else {
            newIconPath = URI.createPlatformPluginURI((String)imageFilePNG.getFullPath().toPortableString(), (boolean)true).toString();
            if (!imageFilePNG.exists()) {
                URL fileURL = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getURL("org.eclipse.papyrus.toolsmiths.nattable", DEFAULT_TABLE_ICON);
                File file = null;
                try {
                    file = new File(FileLocator.resolve((URL)fileURL).toURI());
                }
                catch (URISyntaxException e) {
                    Activator.log.error((Throwable)e);
                }
                catch (IOException e) {
                    Activator.log.error((Throwable)e);
                }
                if (file != null) {
                    try {
                        FileOutputStream out = new FileOutputStream(imageFilePNG.getLocation().toString());
                        Files.copy(file.toPath(), out);
                        ((OutputStream)out).close();
                    }
                    catch (IOException e) {
                        Activator.log.error((Throwable)e);
                        return ExportAsTableConfigurationWizard.createErrorStatus(Messages.ExportAsTableConfigurationWizard_TableIconFileCantBeSaved);
                    }
                } else {
                    return ExportAsTableConfigurationWizard.createErrorStatus(Messages.ExportAsTableConfigurationWizard_TableIconFileCantBeCreated);
                }
            }
        }
        ResourceSetImpl set = new ResourceSetImpl();
        IPath path = folder.getFullPath();
        URI tableConfigurationURI = URI.createPlatformResourceURI((String)path.toPortableString(), (boolean)true);
        tableConfigurationURI = tableConfigurationURI.appendSegment(outputFileName);
        String fileExtension = "nattableconfiguration";
        tableConfigurationURI = tableConfigurationURI.appendFileExtension("nattableconfiguration");
        Resource res = set.createResource(tableConfigurationURI);
        TableToTableConfigurationConverter converter = new TableToTableConfigurationConverter(tableToConvert, newTableName, newTableType, newIconPath, newTableDescription);
        TableConfiguration tc = converter.convertTable();
        res.getContents().add((Object)tc);
        try {
            res.save(null);
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
            return new Status(4, "org.eclipse.papyrus.toolsmiths.nattable", NLS.bind((String)Messages.ExportAsTableConfigurationWizard_ResourceFileCantBeSaved, (Object)tableConfigurationURI.toFileString()));
        }
        TableConfigurationUtils.registerTableConfiguration(outputJavaProject, newTableType, tableConfigurationURI);
        ManifestEditor manifestEditor = null;
        try {
            manifestEditor = new ManifestEditor(outputJavaProject.getProject());
            manifestEditor.init();
        }
        catch (IOException | CoreException e) {
            Activator.log.error(e);
            return ExportAsTableConfigurationWizard.createErrorStatus(Messages.ExportAsTableConfigurationWizard_ManifestEditorCantRegisterDependencies);
        }
        manifestEditor.setSingleton(true);
        ArrayList<String> requiredDependencies = new ArrayList<String>();
        requiredDependencies.add("org.eclipse.papyrus.infra.nattable");
        for (String dependency : requiredDependencies) {
            if (manifestEditor.hasDependency(dependency)) continue;
            manifestEditor.addDependency(dependency);
        }
        manifestEditor.save();
        BuildEditor buildEditor = new BuildEditor(outputJavaProject.getProject());
        buildEditor.init();
        buildEditor.addToBuild(String.valueOf(outputFolderName) + SLASH);
        buildEditor.addToBuild("icons/");
        buildEditor.addToBuild("plugin.xml/");
        buildEditor.save();
        try {
            outputJavaProject.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
        this.checkTableConfigurationDependencies(tableConfigurationURI);
        return Status.OK_STATUS;
    }

    private void checkTableConfigurationDependencies(URI tableConfigurationURI) {
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource secondLoad = resSet.getResource(tableConfigurationURI, true);
        EcoreUtil.resolveAll((Resource)secondLoad);
        if (resSet.getResources().size() > 1) {
            StringBuilder builder = new StringBuilder();
            Iterator iter = resSet.getResources().iterator();
            while (iter.hasNext()) {
                Resource current = (Resource)iter.next();
                if (current == secondLoad) continue;
                current.getURI().isPlatformResource();
                if (current.getURI().isPlatformPlugin()) {
                    String fileExtension = current.getURI().fileExtension();
                    "elementtypesconfigurations".equals(fileExtension);
                }
                builder.append(current.getURI().toString());
                if (!iter.hasNext()) continue;
                builder.append("\n");
            }
            if (builder.length() > 0) {
                String message = NLS.bind((String)Messages.ExportAsTableConfigurationWizard_WarningCreatedTableConfigurationDependsOnSeveralOthersModel, (Object)builder.toString());
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.ExportAsTableConfigurationWizard_CheckTableConfigurationDependencies, (String)message);
            }
        }
    }
}

