/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.xpand.build;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

class EcoreModelResourceVisitor
implements IResourceVisitor,
IResourceDeltaVisitor {
    private static String ECORE_FILE_EXT = "ecore";
    private final IProgressMonitor monitor;
    private final Set<IFile> newEcoreModelFiles = new HashSet<IFile>();
    private final Set<IFile> changedEcoreModelFiles = new HashSet<IFile>();
    private final Set<IFile> removedEcoreModelFiles = new HashSet<IFile>();

    public EcoreModelResourceVisitor(IProgressMonitor progress) {
        this.monitor = progress;
    }

    public Set<IFile> getNewModelFiles() {
        return Collections.unmodifiableSet(this.newEcoreModelFiles);
    }

    public Set<IFile> getChangedModelFiles() {
        return Collections.unmodifiableSet(this.changedEcoreModelFiles);
    }

    public Set<IFile> getRemovedModelFiles() {
        return Collections.unmodifiableSet(this.removedEcoreModelFiles);
    }

    private void handleNewResource(IFile file) {
        this.newEcoreModelFiles.add(file);
    }

    private void handleChangedResource(IFile file) {
        this.changedEcoreModelFiles.add(file);
    }

    private void handleRemoved(IFile file) {
        this.removedEcoreModelFiles.add(file);
    }

    public boolean visit(IResource resource) throws CoreException {
        if (resource.isDerived()) {
            return false;
        }
        if (resource.getType() == 1 && EcoreModelResourceVisitor.isEcoreModel(resource)) {
            this.handleNewResource((IFile)resource);
            this.monitor.worked(1);
            return false;
        }
        return true;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource.isDerived()) {
            return false;
        }
        if (resource.getType() == 1 && EcoreModelResourceVisitor.isEcoreModel(resource)) {
            switch (delta.getKind()) {
                case 1: {
                    this.handleNewResource((IFile)resource);
                    break;
                }
                case 2: {
                    this.handleRemoved((IFile)resource);
                    break;
                }
                case 4: {
                    this.handleChangedResource((IFile)resource);
                }
            }
            this.monitor.worked(1);
            return false;
        }
        return true;
    }

    private static boolean isEcoreModel(IResource file) {
        return ECORE_FILE_EXT.equals(file.getFileExtension());
    }
}

