/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.commands;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class DuplicateStereotypeCommand
extends RecordingCommand {
    protected Element element;
    protected EObject stereotypeApplication;
    protected Stereotype stereotypeInTargetContext;

    public DuplicateStereotypeCommand(TransactionalEditingDomain domain, Element element, EObject stereotypeApplication) {
        this(domain, element, element, stereotypeApplication);
    }

    public DuplicateStereotypeCommand(TransactionalEditingDomain domain, Element element, Element targetContainer, EObject stereotypeApplication) {
        super(domain);
        Stereotype stereotypeInTargetContext;
        this.element = element;
        this.stereotypeApplication = stereotypeApplication;
        Stereotype stereotype = UMLUtil.getStereotype((EObject)stereotypeApplication);
        this.stereotypeInTargetContext = stereotypeInTargetContext = (Stereotype)EMFHelper.reloadIntoContext((EObject)stereotype, (EObject)targetContainer);
    }

    public Stereotype getStereotypeInTargetContext() {
        return this.stereotypeInTargetContext;
    }

    protected void doExecute() {
        EObject applyStereotype = this.element.getStereotypeApplication(this.stereotypeInTargetContext);
        if (applyStereotype == null && this.element.eContainer() != null) {
            applyStereotype = this.element.applyStereotype(this.stereotypeInTargetContext);
        }
        EList eStructuralFeatures = applyStereotype.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature eStructuralFeature : eStructuralFeatures) {
            String name = eStructuralFeature.getName();
            if (name.startsWith("base_") || !eStructuralFeature.isChangeable()) continue;
            if (eStructuralFeature instanceof EReference && ((EReference)eStructuralFeature).isContainment()) {
                Collection listValue;
                Object value = this.stereotypeApplication.eGet(eStructuralFeature);
                if (value instanceof EObject) {
                    EObject valueCopy = EcoreUtil.copy((EObject)((EObject)value));
                    applyStereotype.eSet(eStructuralFeature, (Object)valueCopy);
                    continue;
                }
                if (!(value instanceof Collection) || !(listValue = (Collection)value).stream().allMatch(v -> v instanceof EObject)) continue;
                Collection valueCopy = EcoreUtil.copyAll((Collection)listValue);
                applyStereotype.eSet(eStructuralFeature, (Object)valueCopy);
                continue;
            }
            applyStereotype.eSet(eStructuralFeature, this.stereotypeApplication.eGet(eStructuralFeature));
        }
    }
}

