/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.util;

import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class StyledTextUtils {
    private static final Color STYLED_TEXT_BACKGROUND_COLOR = new Color((Device)Display.getDefault(), new RGB(232, 242, 254));
    private static final Color STYLED_TEXT_FOREGROUND = Display.getCurrent().getSystemColor(16);

    public static final void addLineNumberSupportForXtext(final StyledText styledText) {
        StyledTextUtils.configureLineNumberDisplay(styledText);
        styledText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StyledTextUtils.configureLineNumberDisplay(styledText);
            }
        });
    }

    private static void configureLineNumberDisplay(StyledText styledText) {
        int maxLine1 = styledText.getLineCount();
        StyleRange style = new StyleRange();
        style.foreground = STYLED_TEXT_FOREGROUND;
        style.background = STYLED_TEXT_BACKGROUND_COLOR;
        int bulletLength = Integer.toString(maxLine1).length();
        int bulletWidth = (bulletLength + 1) * styledText.getLineHeight() / 2;
        style.metrics = new GlyphMetrics(0, 0, bulletWidth);
        Bullet bullet1 = new Bullet(2, style);
        styledText.setLineBullet(0, styledText.getLineCount(), null);
        styledText.setLineBullet(0, styledText.getLineCount(), bullet1);
    }

    public static final void addLineNumberSupport(final StyledText styledText) {
        styledText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                styledText.redraw();
            }
        });
        styledText.addLineStyleListener(new LineStyleListener(){

            public void lineGetStyle(LineStyleEvent event) {
                StyleRange styleRange = new StyleRange();
                styleRange.foreground = STYLED_TEXT_FOREGROUND;
                styleRange.background = STYLED_TEXT_BACKGROUND_COLOR;
                int maxLine = styledText.getLineCount();
                int bulletLength = Integer.toString(maxLine).length();
                int bulletWidth = (bulletLength + 1) * styledText.getLineHeight() / 2;
                styleRange.metrics = new GlyphMetrics(0, 0, bulletWidth);
                event.bullet = new Bullet(16, styleRange);
                int bulletLine = styledText.getLineAtOffset(event.lineOffset) + 1;
                event.bullet.text = String.format("%" + bulletLength + "s", bulletLine);
            }
        });
    }
}

