/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.mwe2.utils.components;

import com.google.common.base.Strings;
import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.core.resources.ResourceLoaderFactory;
import org.eclipse.papyrus.mwe2.utils.messages.Messages;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLPlugin;

public class RegisterUmlProfile
extends AbstractWorkflowComponent {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private String profileSlot;
    private String generatedPackageInterfaceName;

    public String getProfileSlot() {
        return this.profileSlot;
    }

    public void setProfileSlot(String profileSlot) {
        this.profileSlot = profileSlot;
    }

    public String getGeneratedPackageInterfaceName() {
        return this.generatedPackageInterfaceName;
    }

    public void setGeneratedPackageInterfaceName(String generatedPackageInterfaceName) {
        this.generatedPackageInterfaceName = generatedPackageInterfaceName;
    }

    public void checkConfiguration(Issues issues) {
        if (this.profileSlot == null || this.profileSlot.equals("")) {
            issues.addError(Messages.RegisterUmlProfile_1);
        }
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        EObject eObject = (EObject)ctx.get(this.profileSlot);
        if (!(eObject instanceof Profile)) {
            this.log.error((Object)Messages.RegisterUmlProfile_2);
            return;
        }
        Profile profile = (Profile)eObject;
        if (!Strings.isNullOrEmpty((String)this.getGeneratedPackageInterfaceName())) {
            try {
                Class clazz = ResourceLoaderFactory.createResourceLoader().loadClass(this.getGeneratedPackageInterfaceName());
                if (clazz == null) {
                    throw new ClassNotFoundException(this.getGeneratedPackageInterfaceName());
                }
                Class<EPackage> packageInterface = clazz.asSubclass(EPackage.class);
                Field eNS_URI = packageInterface.getDeclaredField("eNS_URI");
                String nsURI = (String)eNS_URI.get(null);
                UMLPlugin.getEPackageNsURIToProfileLocationMap().put(nsURI, EcoreUtil.getURI((EObject)profile));
            }
            catch (Exception e) {
                this.log.error((Object)String.format("Failed to register generated profile %s", this.getGeneratedPackageInterfaceName()), (Throwable)e);
            }
        } else {
            EPackage definition = profile.getDefinition();
            if (definition == null) {
                this.log.error((Object)Messages.RegisterUmlProfile_3);
                return;
            }
            EPackage.Registry.INSTANCE.put((Object)definition.getNsURI(), (Object)definition);
        }
    }
}

