/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.xpand.xtend.ast;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.expressions.Helper;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.runtime.util.NonTransformationExecutionContext;
import org.eclipse.papyrus.gmf.internal.xpand.model.AnalysationIssue;
import org.eclipse.papyrus.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.papyrus.gmf.internal.xpand.xtend.ast.QvtExtension;
import org.eclipse.papyrus.gmf.internal.xpand.xtend.ast.QvtResource;

public class QvtFile
implements QvtResource {
    private List<QvtExtension> extensions;
    private final String fileName;
    private final Set<Module> modules;
    private QvtMessage[] errors = new QvtMessage[0];

    public QvtFile(List<Module> modules, String fullyQualifiedName) {
        this.modules = new LinkedHashSet<Module>(modules);
        this.fileName = fullyQualifiedName;
    }

    public QvtFile(CompiledUnit cu, String fullyQualifiedName) {
        this(cu.getModules(), fullyQualifiedName);
        List allErrors = cu.getErrors();
        this.errors = allErrors.toArray(new QvtMessage[allErrors.size()]);
    }

    @Override
    public Set<Module> getModules() {
        return this.modules;
    }

    @Override
    public List<QvtExtension> getExtensions() {
        if (this.extensions == null && this.errors.length == 0) {
            this.extensions = new ArrayList<QvtExtension>();
            if (this.getModules() != null) {
                NonTransformationExecutionContext context = new NonTransformationExecutionContext(this.getModules());
                for (Module module : this.getModules()) {
                    for (EOperation operation : module.getEOperations()) {
                        if (!(operation instanceof Helper)) continue;
                        this.extensions.add(new QvtExtension(context.createHelperCall((Helper)operation), this, this.fileName));
                    }
                }
            }
        }
        return this.extensions;
    }

    @Override
    public void analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        if (this.errors.length > 0) {
            int i = 0;
            while (i < this.errors.length) {
                QvtMessage qvtMessage = this.errors[i];
                if (qvtMessage.getSeverity() == 4) {
                    issues.add(new AnalysationIssue(AnalysationIssue.Type.SYNTAX_ERROR, qvtMessage.toString(), null));
                }
                ++i;
            }
        }
    }

    @Override
    public String[] getImportedExtensions() {
        return new String[0];
    }

    @Override
    public String[] getImportedNamespaces() {
        return new String[0];
    }
}

