/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.graphdef.codegen.ui;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.papyrus.gmf.gmfgraph.DiagramElement;
import org.eclipse.papyrus.gmf.gmfgraph.FigureGallery;
import org.eclipse.papyrus.gmf.graphdef.codegen.StandaloneGenerator;
import org.eclipse.papyrus.gmf.internal.graphdef.codegen.ui.ConverterOptions;
import org.eclipse.papyrus.gmf.internal.graphdef.codegen.ui.ConverterOutcome;
import org.eclipse.papyrus.gmf.internal.graphdef.codegen.ui.FileNameOption;
import org.eclipse.papyrus.gmf.internal.graphdef.codegen.ui.StandaloneGeneratorConfigAdapter;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.pde.ui.templates.BaseOptionTemplateSection;
import org.eclipse.pde.ui.templates.BooleanOption;
import org.eclipse.pde.ui.templates.OptionTemplateSection;
import org.eclipse.pde.ui.templates.TemplateOption;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class ConverterSection
extends OptionTemplateSection {
    private static final String MY_PLUGIN_ID = "org.eclipse.papyrus.gmf.graphdef.codegen.ui";
    private static final String SECTION_ID = "org.eclipse.papyrus.gmf.graphdef.codegen.ui.ConverterSection";
    private static final int THE_ONLY_PAGE_INDEX = 0;
    public static final String OPTION_MAIN_PACKAGE_NAME = "org.eclipse.papyrus.gmf.graphdef.codegen.ui.ConverterSection.mainPackageName";
    public static final String OPTION_NEEDS_MAP_MODE = "org.eclipse.papyrus.gmf.graphdef.codegen.ui.ConverterSection.needsMapMode";
    public static final String OPTION_USE_RUNTIME_FIGURES = "org.eclipse.papyrus.gmf.graphdef.codegen.ui.ConverterSection.useRuntimeFigures";
    public static final String OPTION_INPUT_RESOURCE_FULL_PATH = "org.eclipse.papyrus.gmf.graphdef.codegen.ui.ConverterSection.inputResource";
    public static final String OPTION_OUTPUT_GALLERY_FULL_PATH = "org.eclipse.papyrus.gmf.graphdef.codegen.ui.ConverterSection.outputGallery";
    public static final String OPTION_OUTPUT_DIAGRAM_ELEMENTS_FULL_PATH = "org.eclipse.papyrus.gmf.graphdef.codegen.ui.ConverterSection.outputDiagramElements";
    private TemplateOption myPackageNameOption;
    private FileNameOption myInputPathOption;
    private FileNameOption myOutputGalleryPathOption;
    private FileNameOption myOutputDiagramElementsPathOption;
    private final InputValidationState myCachedInputValidationState;
    private BooleanOption myNeedsMapModeOption;
    private BooleanOption myUseRuntimeFiguresOption;
    private final boolean shouldWarnLiteVerstionDoesNotSupportMapMode;
    private ManifestElement[] myRequiredBundles;

    public ConverterSection() {
        this.setPageCount(1);
        this.myPackageNameOption = this.addOption(OPTION_MAIN_PACKAGE_NAME, "Generate figures package", null, 0);
        this.myInputPathOption = this.addFileNameOption(false, OPTION_INPUT_RESOURCE_FULL_PATH, "Input GMFGraph instance", "", 0);
        this.myOutputGalleryPathOption = this.addFileNameOption(true, OPTION_OUTPUT_GALLERY_FULL_PATH, "Create Figure Gallery", "", 0);
        this.myOutputGalleryPathOption.setRequired(false);
        this.myOutputDiagramElementsPathOption = this.addFileNameOption(true, OPTION_OUTPUT_DIAGRAM_ELEMENTS_FULL_PATH, "Mirror diagram elements", "", 0);
        this.myOutputDiagramElementsPathOption.setRequired(false);
        this.myNeedsMapModeOption = (BooleanOption)this.addOption(OPTION_NEEDS_MAP_MODE, "Use IMapMode", false, 0);
        this.myUseRuntimeFiguresOption = (BooleanOption)this.addOption(OPTION_USE_RUNTIME_FIGURES, "Use Enhanced Figures", true, 0);
        this.myCachedInputValidationState = new InputValidationState(this.myOutputGalleryPathOption, this.myOutputDiagramElementsPathOption);
        this.shouldWarnLiteVerstionDoesNotSupportMapMode = Platform.getBundle((String)"org.eclipse.papyrus.gmf.codegen.lite") != null;
    }

    public void addPages(Wizard wizard) {
        super.addPages(wizard);
        WizardPage page = this.createPage(0);
        page.setDescription("Converts an existing instance of the gmfgraph model into plugin code");
        page.setTitle("Figure definitions converter");
        wizard.addPage((IWizardPage)page);
        this.markPagesAdded();
        this.validateOptions(this.myPackageNameOption);
    }

    public IPluginReference[] getDependencies(String schemaVersion) {
        return new IPluginReference[0];
    }

    protected void generateFiles(IProgressMonitor monitor) throws CoreException {
        Resource input = ConverterSection.loadResource(this.myInputPathOption.getText());
        StandaloneGeneratorConfigAdapter config = new StandaloneGeneratorConfigAdapter(this);
        ConverterOptions options = this.newConverterOptions();
        ConverterOutcome converterOutcome = new ConverterOutcome(options, new Resource[]{input});
        assert (converterOutcome.checkInputAgainstOptions().isOK());
        StandaloneGenerator generator = new StandaloneGenerator(converterOutcome.getProcessor(), (StandaloneGenerator.Config)config);
        generator.setSkipPluginStructure(false);
        try {
            try {
                generator.run((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.readRequiredBundles();
                if (!generator.getRunStatus().isOK()) {
                    throw new CoreException(generator.getRunStatus());
                }
                IStatus s = converterOutcome.createResources((ResourceSet)new ResourceSetImpl(), URI.createFileURI((String)this.myOutputGalleryPathOption.getText()), URI.createFileURI((String)this.myOutputDiagramElementsPathOption.getText()));
                if (s.getSeverity() == 4) {
                    throw new CoreException(s);
                }
            }
            catch (InterruptedException e) {
                String message = e.getMessage();
                if (message == null) {
                    message = "Interrupted";
                }
                throw new CoreException((IStatus)new Status(4, MY_PLUGIN_ID, 0, message, (Throwable)e));
            }
            catch (IOException ex) {
                throw new CoreException((IStatus)new Status(4, MY_PLUGIN_ID, 0, "Failed to read generated manifest.mf", (Throwable)ex));
            }
        }
        finally {
            input.unload();
        }
    }

    private ConverterOptions newConverterOptions() {
        ConverterOptions options = new ConverterOptions();
        options.needMirroredGalleries = ConverterSection.shouldGenerate(this.myOutputGalleryPathOption);
        options.needMirroredCanvas = ConverterSection.shouldGenerate(this.myOutputDiagramElementsPathOption);
        options.separateMirrorFiles = options.needMirroredCanvas && this.myOutputGalleryPathOption.getText().equals(this.myOutputDiagramElementsPathOption.getText());
        return options;
    }

    private static boolean shouldGenerate(FileNameOption option) {
        return option.isEnabled() && !option.isEmpty();
    }

    private void readRequiredBundles() throws CoreException, IOException {
        try {
            IFile f = this.findGeneratedManifest();
            if (f == null || !f.exists()) {
                return;
            }
            InputStream is = f.getContents();
            String requiredBundles = new Manifest(is).getMainAttributes().getValue("Require-Bundle");
            is.close();
            this.myRequiredBundles = ManifestElement.parseHeader((String)"Require-Bundle", (String)requiredBundles);
        }
        catch (BundleException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    private IFile findGeneratedManifest() {
        return (IFile)this.project.findMember((IPath)new Path("META-INF/MANIFEST.MF"));
    }

    public String getPluginActivatorClassFQN() {
        return this.model instanceof IPluginModel ? ((IPluginModel)this.model).getPlugin().getClassName() : null;
    }

    public String getPluginFriendlyName() {
        return this.model.getPluginBase().getName();
    }

    public String getPluginID() {
        return this.model.getPluginBase().getId();
    }

    public String getPluginProviderName() {
        return this.model.getPluginBase().getProviderName();
    }

    protected URL getInstallURL() {
        return this.getContributingBundle().getEntry("/");
    }

    public String getSectionId() {
        return SECTION_ID;
    }

    public void validateOptions(TemplateOption changed) {
        if ((this.myUseRuntimeFiguresOption.equals(changed) || this.myNeedsMapModeOption.equals(changed)) && this.shouldWarnLiteVerstionDoesNotSupportMapMode) {
            boolean useRuntimeFigures = this.myUseRuntimeFiguresOption.isSelected();
            boolean needsMapMode = this.myNeedsMapModeOption.isSelected();
            if (!useRuntimeFigures && needsMapMode) {
                this.getTheOnlyPage().setMessage("It is not recommended to use IMapMode for pure-GEF diagram editors", 1);
            } else {
                this.getTheOnlyPage().setMessage(null);
            }
        }
        if (OPTION_NEEDS_MAP_MODE.equals(changed)) {
            return;
        }
        if (this.validateInputPath() && this.validatePackageName() && this.validateOutputOption(this.myOutputDiagramElementsPathOption) && this.validateOutputOption(this.myOutputGalleryPathOption)) {
            this.resetPageState();
        }
    }

    public boolean isDependentOnParentWizard() {
        return true;
    }

    protected void initializeFields(IFieldData data) {
        super.initializeFields(data);
        String packageName = this.getFormattedPackageName(data.getId());
        this.initializeOption(OPTION_MAIN_PACKAGE_NAME, packageName);
    }

    protected ResourceBundle getPluginResourceBundle() {
        return Platform.getResourceBundle((Bundle)this.getContributingBundle());
    }

    protected void updateModel(IProgressMonitor monitor) throws CoreException {
        if (this.myRequiredBundles == null) {
            return;
        }
        int i = 0;
        while (i < this.myRequiredBundles.length) {
            this.addImport(this.myRequiredBundles[i].getValueComponents()[0]);
            ++i;
        }
    }

    private void addImport(String importedPluginId) throws CoreException {
        IPluginImport pluginImport = this.model.getPluginFactory().createImport();
        pluginImport.setId(importedPluginId);
        this.model.getPluginBase().add(pluginImport);
    }

    public String[] getNewFiles() {
        return new String[0];
    }

    public String getUsedExtensionPoint() {
        return null;
    }

    private Bundle getContributingBundle() {
        return Platform.getBundle((String)MY_PLUGIN_ID);
    }

    private String getFormattedPackageName(String id) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < id.length()) {
            char ch = id.charAt(i);
            if (buffer.length() == 0) {
                if (Character.isJavaIdentifierStart(ch)) {
                    buffer.append(Character.toLowerCase(ch));
                }
            } else if (Character.isJavaIdentifierPart(ch) || ch == '.') {
                buffer.append(ch);
            }
            ++i;
        }
        return buffer.toString().toLowerCase(Locale.ENGLISH);
    }

    private FileNameOption addFileNameOption(boolean saveNotLoad, String name, String label, String value, int pageIndex) {
        FileNameOption result = new FileNameOption((BaseOptionTemplateSection)this, name, label, new String[]{"*.gmfgraph"});
        result.setSaveNotLoad(saveNotLoad);
        this.registerOption(result, value, pageIndex);
        return result;
    }

    private boolean validatePackageName() {
        boolean isValid;
        boolean bl = isValid = !this.myPackageNameOption.isEmpty();
        if (!isValid) {
            this.flagMissingRequiredOption(this.myPackageNameOption);
        }
        return isValid;
    }

    private boolean validateInputPath() {
        if (this.myInputPathOption.isEmpty()) {
            this.flagMissingRequiredOption(this.myInputPathOption);
            this.myOutputDiagramElementsPathOption.setEnabled(false);
            this.myOutputGalleryPathOption.setEnabled(false);
            return false;
        }
        String path = this.myInputPathOption.getText();
        this.myCachedInputValidationState.updateInput(path);
        if (!this.myCachedInputValidationState.isValid()) {
            this.flagError(this.myCachedInputValidationState.getErrorMessage());
            return false;
        }
        return true;
    }

    private boolean validateOutputOption(FileNameOption option) {
        if (!option.isEnabled()) {
            return false;
        }
        if (!this.validateMirrorDiagramWithoutFigureGallery()) {
            return false;
        }
        if (option.isEmpty()) {
            return true;
        }
        String path = option.getText();
        return this.validatePath(path);
    }

    private boolean validateMirrorDiagramWithoutFigureGallery() {
        if (!this.myOutputDiagramElementsPathOption.isEmpty() && (this.myOutputGalleryPathOption.isEmpty() || this.myOutputDiagramElementsPathOption.getText().equals(this.myOutputGalleryPathOption.getText()))) {
            this.flagError("In order to mirror diagram elements you have to generate separate figure gallery");
            return false;
        }
        return true;
    }

    private boolean validatePath(String path) {
        try {
            return URI.createFileURI((String)path) != null;
        }
        catch (IllegalArgumentException e) {
            this.flagError(MessageFormat.format("Path {0} is invalid", path));
            return false;
        }
    }

    private WizardPage getTheOnlyPage() {
        return this.getPage(0);
    }

    private void flagError(String message) {
        this.getTheOnlyPage().setPageComplete(false);
        this.getTheOnlyPage().setErrorMessage(message);
    }

    private static Resource loadResource(String path) {
        Resource resource = new ResourceSetImpl().createResource(URI.createFileURI((String)path), "");
        try {
            resource.load(Collections.EMPTY_MAP);
            return resource;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static class InputValidationState {
        private String myCachedPath;
        private String myCachedErrorMessage;
        private boolean myHasDiagramElement;
        private boolean myHasFigure;
        private final FileNameOption myDiagramElementsOption;
        private final FileNameOption myGalleryOption;

        public InputValidationState(FileNameOption galleryOption, FileNameOption diagramElementsOption) {
            this.myGalleryOption = galleryOption;
            this.myDiagramElementsOption = diagramElementsOption;
        }

        public void updateInput(String path) {
            if (this.myCachedPath == null || !this.myCachedPath.equals(path)) {
                this.myCachedPath = path;
                this.validateInputPath(path);
                this.myGalleryOption.setEnabled(this.myHasFigure);
                this.myDiagramElementsOption.setEnabled(this.myHasDiagramElement);
            }
        }

        public boolean isValid() {
            return this.myHasFigure;
        }

        public String getErrorMessage() {
            return this.myCachedErrorMessage;
        }

        private void validateInputPath(String path) {
            this.myHasDiagramElement = false;
            this.myHasFigure = false;
            this.myCachedErrorMessage = null;
            if (path == null || !new File(path).exists()) {
                this.myCachedErrorMessage = MessageFormat.format("Can not find file {0}", path);
                return;
            }
            Resource resource = ConverterSection.loadResource(path);
            if (resource != null) {
                this.classifyContents(resource);
            }
            if (!this.myHasFigure) {
                this.myCachedErrorMessage = MessageFormat.format("File {0} does not contain any figure definitions", path);
            }
        }

        private void classifyContents(Resource resource) {
            this.myHasDiagramElement = false;
            this.myHasFigure = false;
            TreeIterator contents = resource.getAllContents();
            while (contents.hasNext()) {
                EObject next = (EObject)contents.next();
                if (next instanceof FigureGallery) {
                    if (!this.myHasFigure) {
                        FigureGallery nextGallery = (FigureGallery)next;
                        this.myHasFigure = !nextGallery.getFigures().isEmpty();
                    }
                    contents.prune();
                }
                if (next instanceof DiagramElement) {
                    this.myHasDiagramElement = true;
                    contents.prune();
                }
                if (this.myHasDiagramElement && this.myHasFigure) break;
            }
        }
    }
}

