/**
 * Copyright (c) 2013-2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Michael Golubev (Montages) - initial API and implementation
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
@SuppressWarnings("all")
public class CodeStyle {
  @Inject
  @Extension
  private GenEditorGenerator_qvto _genEditorGenerator_qvto;
  
  @Inject
  @Extension
  private Common _common;
  
  /**
   * FIXME: [MG] inline this, we now safely assume everywhere that it is > 4
   */
  public CharSequence overrideC(final GenCommonBase xptSelf) {
    StringConcatenation _builder = new StringConcatenation();
    {
      int _jdkComplianceLevel = this._genEditorGenerator_qvto.jdkComplianceLevel(xptSelf);
      boolean _greaterThan = (_jdkComplianceLevel > 4);
      if (_greaterThan) {
        _builder.append("@Override");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence overrideI(final GenCommonBase xptSelf) {
    StringConcatenation _builder = new StringConcatenation();
    {
      int _jdkComplianceLevel = this._genEditorGenerator_qvto.jdkComplianceLevel(xptSelf);
      boolean _greaterThan = (_jdkComplianceLevel > 5);
      if (_greaterThan) {
        _builder.append("@Override");
        _builder.newLine();
      } else {
        CharSequence _extraLineBreak = this._common.extraLineBreak();
        _builder.append(_extraLineBreak);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  /**
   * FIXME: [MG] inline this, we now safely assume everywhere that it is > 4
   */
  public CharSequence SuppressWarnings(final GenEditorGenerator xptSelf, final String warnToken) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _SuppressWarnings = this.SuppressWarnings(xptSelf.getDiagram(), warnToken);
    _builder.append(_SuppressWarnings);
    return _builder;
  }
  
  /**
   * FIXME: [MG] inline this, we now safely assume everywhere that it is > 4
   */
  public CharSequence SuppressWarnings(final GenCommonBase xptSelf, final String warnToken) {
    StringConcatenation _builder = new StringConcatenation();
    {
      int _jdkComplianceLevel = this._genEditorGenerator_qvto.jdkComplianceLevel(xptSelf);
      boolean _greaterThan = (_jdkComplianceLevel > 4);
      if (_greaterThan) {
        _builder.append("@SuppressWarnings(");
        _builder.append(warnToken);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
}
