/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Artem Tikhomirov (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package gmfgraph.attr;

import com.google.common.base.Objects;
import com.google.inject.Singleton;
import java.util.Arrays;
import org.eclipse.papyrus.gmf.gmfgraph.LineKind;
import org.eclipse.papyrus.gmf.gmfgraph.Polygon;
import org.eclipse.xtend2.lib.StringConcatenation;

/**
 * org.eclipse.draw2d.Shape
 * 	private boolean fill = true, outline = true, xorFill, xorOutline;
 * 	lineAttributes.width = 1.0
 * 	lineAttributes.style = LINE_SOLID
 */
@Singleton
@SuppressWarnings("all")
public class Shape {
  public CharSequence shapeAttrs(final org.eclipse.papyrus.gmf.gmfgraph.Shape it, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _fill = this.fill(it, figureVarName);
    _builder.append(_fill);
    _builder.newLineIfNotEmpty();
    {
      boolean _isXorFill = it.isXorFill();
      if (_isXorFill) {
        CharSequence _xorFill = this.xorFill(it, figureVarName);
        _builder.append(_xorFill);
      }
    }
    _builder.newLineIfNotEmpty();
    {
      boolean _isOutline = it.isOutline();
      boolean _not = (!_isOutline);
      if (_not) {
        CharSequence _outline = this.outline(it, figureVarName);
        _builder.append(_outline);
      }
    }
    _builder.newLineIfNotEmpty();
    {
      boolean _isXorOutline = it.isXorOutline();
      if (_isXorOutline) {
        CharSequence _xorOutline = this.xorOutline(it, figureVarName);
        _builder.append(_xorOutline);
      }
    }
    _builder.newLineIfNotEmpty();
    {
      int _lineWidth = it.getLineWidth();
      boolean _notEquals = (_lineWidth != 1);
      if (_notEquals) {
        CharSequence _lineWidth_1 = this.lineWidth(it, figureVarName);
        _builder.append(_lineWidth_1);
      }
    }
    _builder.newLineIfNotEmpty();
    {
      LineKind _lineKind = it.getLineKind();
      boolean _notEquals_1 = (!Objects.equal(_lineKind, LineKind.LINE_SOLID_LITERAL));
      if (_notEquals_1) {
        CharSequence _lineKind_1 = this.lineKind(it, figureVarName);
        _builder.append(_lineKind_1);
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _fill(final org.eclipse.papyrus.gmf.gmfgraph.Shape it, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isFill = it.isFill();
      boolean _not = (!_isFill);
      if (_not) {
        _builder.append(figureVarName);
        _builder.append(".setFill(");
        boolean _isFill_1 = it.isFill();
        _builder.append(_isFill_1);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  protected CharSequence _fill(final Polygon it, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isFill = it.isFill();
      if (_isFill) {
        _builder.append(figureVarName);
        _builder.append(".setFill(");
        boolean _isFill_1 = it.isFill();
        _builder.append(_isFill_1);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence xorFill(final org.eclipse.papyrus.gmf.gmfgraph.Shape it, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(figureVarName);
    _builder.append(".setFillXOR(");
    boolean _isXorFill = it.isXorFill();
    _builder.append(_isXorFill);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence outline(final org.eclipse.papyrus.gmf.gmfgraph.Shape it, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(figureVarName);
    _builder.append(".setOutline(");
    boolean _isOutline = it.isOutline();
    _builder.append(_isOutline);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence xorOutline(final org.eclipse.papyrus.gmf.gmfgraph.Shape it, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(figureVarName);
    _builder.append(".setOutlineXOR(");
    boolean _isXorOutline = it.isXorOutline();
    _builder.append(_isXorOutline);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence lineWidth(final org.eclipse.papyrus.gmf.gmfgraph.Shape it, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(figureVarName);
    _builder.append(".setLineWidth(");
    int _lineWidth = it.getLineWidth();
    _builder.append(_lineWidth);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence lineKind(final org.eclipse.papyrus.gmf.gmfgraph.Shape it, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(figureVarName);
    _builder.append(".setLineStyle(org.eclipse.draw2d.Graphics.");
    LineKind _lineKind = it.getLineKind();
    _builder.append(_lineKind);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence fill(final org.eclipse.papyrus.gmf.gmfgraph.Shape it, final String figureVarName) {
    if (it instanceof Polygon) {
      return _fill((Polygon)it, figureVarName);
    } else if (it != null) {
      return _fill(it, figureVarName);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, figureVarName).toString());
    }
  }
}
