/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Artem Tikhomirov (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package gmfgraph.attr;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import gmfgraph.Border;
import gmfgraph.MapMode;
import gmfgraph.Utils_Statefull_qvto;
import gmfgraph.Utils_qvto;
import java.util.Arrays;
import org.eclipse.papyrus.gmf.gmfgraph.BasicFont;
import org.eclipse.papyrus.gmf.gmfgraph.Color;
import org.eclipse.papyrus.gmf.gmfgraph.ColorConstants;
import org.eclipse.papyrus.gmf.gmfgraph.ConstantColor;
import org.eclipse.papyrus.gmf.gmfgraph.Dimension;
import org.eclipse.papyrus.gmf.gmfgraph.Font;
import org.eclipse.papyrus.gmf.gmfgraph.FontStyle;
import org.eclipse.papyrus.gmf.gmfgraph.Insets;
import org.eclipse.papyrus.gmf.gmfgraph.Point;
import org.eclipse.papyrus.gmf.gmfgraph.RGBColor;
import org.eclipse.papyrus.gmf.gmfgraph.RealFigure;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;
import xpt.Common_qvto;

@Singleton
@SuppressWarnings("all")
public class Figure {
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private Utils_qvto _utils_qvto;
  
  @Inject
  @Extension
  private Utils_Statefull_qvto _utils_Statefull_qvto;
  
  @Inject
  private MapMode xptMapMode;
  
  @Inject
  private Border xptBorder;
  
  @Inject
  private CustomAttributeOwner xptCustomAttributeOwner;
  
  public CharSequence figureAttrs(final org.eclipse.papyrus.gmf.gmfgraph.Figure it, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _foregroundColor = this.foregroundColor(it.getForegroundColor(), figureVarName);
    _builder.append(_foregroundColor);
    _builder.newLineIfNotEmpty();
    CharSequence _backgroundColor = this.backgroundColor(it.getBackgroundColor(), figureVarName);
    _builder.append(_backgroundColor);
    _builder.newLineIfNotEmpty();
    {
      Font _font = it.getFont();
      boolean _notEquals = (!Objects.equal(_font, null));
      if (_notEquals) {
        CharSequence _font_1 = this.font(it.getFont(), figureVarName);
        _builder.append(_font_1);
      }
    }
    _builder.newLineIfNotEmpty();
    CharSequence _preferredSize = this.preferredSize(it.getPreferredSize(), figureVarName);
    _builder.append(_preferredSize);
    _builder.newLineIfNotEmpty();
    CharSequence _maximumSize = this.maximumSize(it.getMaximumSize(), figureVarName);
    _builder.append(_maximumSize);
    _builder.newLineIfNotEmpty();
    CharSequence _minimumSize = this.minimumSize(it.getMinimumSize(), figureVarName);
    _builder.append(_minimumSize);
    _builder.newLineIfNotEmpty();
    CharSequence _position = this.position(it.getLocation(), figureVarName);
    _builder.append(_position);
    _builder.newLineIfNotEmpty();
    CharSequence _size = this.size(it.getSize(), figureVarName);
    _builder.append(_size);
    _builder.newLineIfNotEmpty();
    CharSequence _insets = this.insets(it.getInsets(), figureVarName);
    _builder.append(_insets);
    _builder.newLineIfNotEmpty();
    CharSequence _Init = this.xptBorder.Init(it.getBorder(), figureVarName);
    _builder.append(_Init);
    _builder.newLineIfNotEmpty();
    CharSequence _dispatch_customAttributes = this.dispatch_customAttributes(it, figureVarName);
    _builder.append(_dispatch_customAttributes);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence foregroundColor(final Color color, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _notEquals = (!Objects.equal(color, null));
      if (_notEquals) {
        _builder.append(figureVarName);
        _builder.append(".setForegroundColor(");
        CharSequence _color = this.color(color, this._utils_qvto.foregroundColorVariableName(color, figureVarName));
        _builder.append(_color);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence backgroundColor(final Color color, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _notEquals = (!Objects.equal(color, null));
      if (_notEquals) {
        _builder.append(figureVarName);
        _builder.append(".setBackgroundColor(");
        CharSequence _color = this.color(color, this._utils_qvto.backgroundColorVariableName(color, figureVarName));
        _builder.append(_color);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence preferredSize(final Dimension dim, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _notEquals = (!Objects.equal(dim, null));
      if (_notEquals) {
        _builder.append(figureVarName);
        _builder.append(".setPreferredSize(new org.eclipse.draw2d.geometry.Dimension(");
        CharSequence _mapMode = this.xptMapMode.mapMode(dim);
        _builder.append(_mapMode);
        _builder.append("));");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence maximumSize(final Dimension dim, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _notEquals = (!Objects.equal(dim, null));
      if (_notEquals) {
        _builder.append(figureVarName);
        _builder.append(".setMaximumSize(new org.eclipse.draw2d.geometry.Dimension(");
        CharSequence _mapMode = this.xptMapMode.mapMode(dim);
        _builder.append(_mapMode);
        _builder.append("));");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence minimumSize(final Dimension dim, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _notEquals = (!Objects.equal(dim, null));
      if (_notEquals) {
        _builder.append(figureVarName);
        _builder.append(".setMinimumSize(new org.eclipse.draw2d.geometry.Dimension(");
        CharSequence _mapMode = this.xptMapMode.mapMode(dim);
        _builder.append(_mapMode);
        _builder.append("));");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence position(final Point point, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _notEquals = (!Objects.equal(point, null));
      if (_notEquals) {
        _builder.append(figureVarName);
        _builder.append(".setLocation(new org.eclipse.draw2d.geometry.Point(");
        CharSequence _mapMode = this.xptMapMode.mapMode(point);
        _builder.append(_mapMode);
        _builder.append("));");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence size(final Point point, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _notEquals = (!Objects.equal(point, null));
      if (_notEquals) {
        _builder.append(figureVarName);
        _builder.append(".setSize(");
        CharSequence _mapMode = this.xptMapMode.mapMode(point);
        _builder.append(_mapMode);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  /**
   * using MarginBorder for insets is not good idea (?)
   */
  public CharSequence insets(final Insets insets, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _notEquals = (!Objects.equal(insets, null));
      if (_notEquals) {
        CharSequence _extraLineBreak = this._common.extraLineBreak();
        _builder.append(_extraLineBreak);
        _builder.newLineIfNotEmpty();
        _builder.append(figureVarName);
        _builder.append(".setBorder(new org.eclipse.draw2d.MarginBorder(");
        CharSequence _mapMode = this.xptMapMode.mapMode(insets);
        _builder.append(_mapMode);
        _builder.append("));");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  protected CharSequence _color(final Color it, final String variableName) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("This is abstract definition, missing concrete def for: " + it));
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _color(final RGBColor it, final String variableName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(variableName);
    _builder.newLineIfNotEmpty();
    StringConcatenation _builder_1 = new StringConcatenation();
    CharSequence _color_staticFields = this.color_staticFields(it, variableName);
    _builder_1.append(_color_staticFields);
    this._utils_Statefull_qvto.addToStaticStream(_builder_1);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _color(final ConstantColor it, final String variableName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.draw2d.ColorConstants.");
    ColorConstants _value = it.getValue();
    _builder.append(_value);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _color_staticFields(final Color it, final String variableName) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  protected CharSequence _color_staticFields(final RGBColor it, final String variableName) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("static final org.eclipse.swt.graphics.Color ");
    _builder.append(variableName);
    _builder.append(" = new org.eclipse.swt.graphics.Color(null, ");
    int _red = it.getRed();
    _builder.append(_red);
    _builder.append(", ");
    int _green = it.getGreen();
    _builder.append(_green);
    _builder.append(", ");
    int _blue = it.getBlue();
    _builder.append(_blue);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    CharSequence _extraLineBreak = this._common.extraLineBreak();
    _builder.append(_extraLineBreak);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _font(final Font it, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(("This is abstract definition, missing concrete def for: " + it));
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _font(final BasicFont it, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _extraLineBreak = this._common.extraLineBreak();
    _builder.append(_extraLineBreak);
    _builder.newLineIfNotEmpty();
    _builder.append(figureVarName);
    _builder.append(".setFont(");
    String _fontVariableName = this._utils_qvto.fontVariableName(it, figureVarName);
    _builder.append(_fontVariableName);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    StringConcatenation _builder_1 = new StringConcatenation();
    CharSequence _font_staticFields = this.font_staticFields(it, figureVarName);
    _builder_1.append(_font_staticFields);
    this._utils_Statefull_qvto.addToStaticStream(_builder_1);
    _builder.newLineIfNotEmpty();
    CharSequence _extraLineBreak_1 = this._common.extraLineBreak();
    _builder.append(_extraLineBreak_1);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _font_staticFields(final Font it, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  protected CharSequence _font_staticFields(final BasicFont it, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("static final org.eclipse.swt.graphics.Font ");
    String _fontVariableName = this._utils_qvto.fontVariableName(it, figureVarName);
    _builder.append(_fontVariableName);
    _builder.append(" = new org.eclipse.swt.graphics.Font(org.eclipse.swt.widgets.Display.getCurrent(), ");
    {
      boolean _nullOrSpaces = this._common_qvto.nullOrSpaces(it.getFaceName());
      if (_nullOrSpaces) {
        _builder.append("org.eclipse.swt.widgets.Display.getDefault().getSystemFont().getFontData()[0].getName()");
      } else {
        _builder.append("\"");
        String _faceName = it.getFaceName();
        _builder.append(_faceName);
        _builder.append("\"");
      }
    }
    _builder.append(", ");
    int _height = it.getHeight();
    _builder.append(_height);
    _builder.append(", org.eclipse.swt.SWT.");
    FontStyle _style = it.getStyle();
    _builder.append(_style);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _dispatch_customAttributes(final Figure it, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  protected CharSequence _dispatch_customAttributes(final RealFigure it, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _customAttributes = this.xptCustomAttributeOwner.customAttributes(it, figureVarName);
    _builder.append(_customAttributes);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence color(final Color it, final String variableName) {
    if (it instanceof ConstantColor) {
      return _color((ConstantColor)it, variableName);
    } else if (it instanceof RGBColor) {
      return _color((RGBColor)it, variableName);
    } else if (it != null) {
      return _color(it, variableName);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, variableName).toString());
    }
  }
  
  public CharSequence color_staticFields(final Color it, final String variableName) {
    if (it instanceof RGBColor) {
      return _color_staticFields((RGBColor)it, variableName);
    } else if (it != null) {
      return _color_staticFields(it, variableName);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, variableName).toString());
    }
  }
  
  public CharSequence font(final Font it, final String figureVarName) {
    if (it instanceof BasicFont) {
      return _font((BasicFont)it, figureVarName);
    } else if (it != null) {
      return _font(it, figureVarName);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, figureVarName).toString());
    }
  }
  
  public CharSequence font_staticFields(final Font it, final String figureVarName) {
    if (it instanceof BasicFont) {
      return _font_staticFields((BasicFont)it, figureVarName);
    } else if (it != null) {
      return _font_staticFields(it, figureVarName);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, figureVarName).toString());
    }
  }
  
  public CharSequence dispatch_customAttributes(final Object it, final String figureVarName) {
    if (it instanceof RealFigure) {
      return _dispatch_customAttributes((RealFigure)it, figureVarName);
    } else if (it instanceof Figure) {
      return _dispatch_customAttributes((Figure)it, figureVarName);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, figureVarName).toString());
    }
  }
}
