/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.bridge.transform;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.papyrus.gmf.internal.bridge.ui.Plugin;
import org.eclipse.papyrus.gmf.internal.common.ui.ModelSelectionPage;
import org.eclipse.papyrus.gmf.internal.common.ui.ResourceLocationProvider;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ModelConfigurationPage
extends ModelSelectionPage {
    public ModelConfigurationPage(String pageId, ResourceLocationProvider rlp, ResourceSet resourceSet) {
        super(pageId, rlp, resourceSet);
    }

    protected Resource loadResource() {
        Resource current = this.getResource();
        if (current != null) {
            current.getResourceSet().getResources().remove((Object)current);
        }
        final Resource[] result = new Resource[1];
        WorkspaceModifyOperation initializeOperation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor progressMonitor) throws CoreException {
                SubProgressMonitor monitor = null;
                try {
                    try {
                        monitor = progressMonitor != null ? new SubProgressMonitor(progressMonitor, 1, 4) : new NullProgressMonitor();
                        ModelConfigurationPage.this.setStatusMessage(Status.OK_STATUS);
                        result[0] = ModelConfigurationPage.this.doLoadResource((IProgressMonitor)monitor);
                    }
                    catch (CoreException exception) {
                        throw exception;
                    }
                    catch (Exception exception) {
                        throw new CoreException(Plugin.createError(exception.getMessage(), exception));
                    }
                }
                finally {
                    if (monitor != null) {
                        monitor.done();
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)initializeOperation);
            this.setStatusMessage(Status.OK_STATUS);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof CoreException) {
                CoreException ce = (CoreException)target;
                this.setStatusMessage(ce.getStatus());
            } else {
                this.setStatusMessage(Plugin.createError(target.getMessage(), target));
            }
        }
        catch (InterruptedException e) {
            this.setStatusMessage(Status.CANCEL_STATUS);
        }
        return result[0];
    }

    protected Resource doLoadResource(IProgressMonitor monitor) throws CoreException {
        try {
            Resource r;
            Resource resource = r = super.loadResource();
            return resource;
        }
        catch (Exception e) {
            throw new CoreException(Plugin.createError(e.getMessage(), e));
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    void setStatusMessage(IStatus status) {
        if (status == null || status.isOK()) {
            this.setMessage(null);
            this.setErrorMessage(null);
        } else if (1 == status.getSeverity()) {
            this.setMessage(status.getMessage(), 1);
            this.setErrorMessage(null);
        } else if (2 == status.getSeverity()) {
            this.setMessage(status.getMessage(), 2);
            this.setErrorMessage(null);
        } else if (4 == status.getSeverity()) {
            this.setMessage(null);
            this.setErrorMessage(status.getMessage());
        } else if (8 == status.getSeverity()) {
            this.setMessage(null);
            this.setErrorMessage(status.getMessage());
        }
    }
}

