/**
 * Copyright (c) 2006, 2010, 2013 Borland Software Corporation and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Alexander Shatalin (Borland) - initial API and implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * Modified by Patrick Tessier (CEA LIST)
 * Emilien Perico (Atos Origin) - update template for GMF 2.2 compliance
 */
package aspects.xpt.navigator;

import aspects.xpt.Common;
import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import metamodel.MetaModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LabelModelFacet;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import parsers.ParserProvider;
import plugin.Activator;
import xpt.navigator.Utils_qvto;

@Singleton
@SuppressWarnings("all")
public class NavigatorLabelProvider extends xpt.navigator.NavigatorLabelProvider {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private Utils_qvto _utils_qvto;
  
  @Inject
  private Activator xptActivator;
  
  @Inject
  private ParserProvider xptParserProvider;
  
  @Inject
  private MetaModel xptMetaModel;
  
  @Override
  public CharSequence getTextMethodName(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("get");
    String _stringUniqueIdentifier = this._common.stringUniqueIdentifier(it);
    _builder.append(_stringUniqueIdentifier);
    _builder.append("Text");
    return _builder;
  }
  
  @Override
  public CharSequence getDiagramLabelText(final GenCommonBase it, final GenCommonBase elementTypeHolder, final LabelModelFacet labelModelFacet) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.gmf.runtime.common.ui.services.parser.IParser parser = ");
    CharSequence _accessorCall = this.xptParserProvider.accessorCall(it, elementTypeHolder, labelModelFacet, "view.getElement() != null ? view.getElement() : view");
    _builder.append(_accessorCall);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("if (parser != null) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return parser.getPrintString(new org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter(view.getElement() != null ? view.getElement() : view), org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions.NONE.intValue());");
    _builder.newLine();
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getDiagram().getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName, "\t");
    _builder.append(".getInstance().logError(\"Parser was not found for label ");
    String _stringVisualID = this._common.stringVisualID(it);
    _builder.append(_stringVisualID, "\t");
    _builder.append("\"); ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _returnEmptyString = this.returnEmptyString();
    _builder.append(_returnEmptyString, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence getLabelFeatureText(final GenCommonBase it, final GenClass genClass) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((!Objects.equal(null, genClass)) && (!Objects.equal(null, genClass.getLabelFeature())))) {
        CharSequence _DeclareAndAssign = this.xptMetaModel.DeclareAndAssign(genClass, "domainModelElement", "view.getElement()");
        _builder.append(_DeclareAndAssign);
        _builder.newLineIfNotEmpty();
        _builder.append("if (domainModelElement != null) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return ");
        {
          boolean _isStringFeature = this._utils_qvto.isStringFeature(genClass.getLabelFeature());
          boolean _not = (!_isStringFeature);
          if (_not) {
            _builder.append("String.valueOf(");
          }
        }
        _builder.append("UMLLabelInternationalization.getInstance().getLabel(domainModelElement)");
        {
          boolean _isStringFeature_1 = this._utils_qvto.isStringFeature(genClass.getLabelFeature());
          boolean _not_1 = (!_isStringFeature_1);
          if (_not_1) {
            _builder.append(")");
          }
        }
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getDiagram().getEditorGen().getPlugin());
        _builder.append(_qualifiedClassName, "\t");
        _builder.append(".getInstance().logError(\"No domain element for view with visualID = ");
        String _stringVisualID = this._common.stringVisualID(it);
        _builder.append(_stringVisualID, "\t");
        _builder.append("\");  ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append(_nonNLS, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _returnEmptyString = this.returnEmptyString();
        _builder.append(_returnEmptyString, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
      } else {
        CharSequence _returnEmptyString_1 = this.returnEmptyString();
        _builder.append(_returnEmptyString_1);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
}
