/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.databinding;

import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.databinding.observable.AbstractObservable;
import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;

public interface ReferenceCountedObservable
extends IObservable {
    public void retain();

    public void release();

    public void autorelease();

    public static abstract class Abstract
    extends AbstractObservable
    implements ReferenceCountedObservable {
        private final Support refCount = new Support(this);

        public Abstract(Realm realm) {
            super(realm);
        }

        @Override
        public void retain() {
            this.refCount.retain();
        }

        @Override
        public void release() {
            this.refCount.release();
        }

        @Override
        public void autorelease() {
            this.refCount.autorelease();
        }
    }

    public static final class AutoReleasePool {
        private static final ConcurrentMap<Realm, AutoReleasePool> pools = new MapMaker().concurrencyLevel(1).makeMap();
        private final Realm realm;
        private Collection<IObservable> pool = Lists.newArrayList();

        private AutoReleasePool(Realm realm) {
            this.realm = realm;
            realm.asyncExec((Runnable)new ReleaseRunnable());
        }

        public static AutoReleasePool get(Realm realm) {
            AutoReleasePool oops;
            AutoReleasePool result = (AutoReleasePool)pools.get(realm);
            if (result == null && (oops = pools.putIfAbsent(realm, result = new AutoReleasePool(realm))) != null) {
                result = oops;
            }
            return result;
        }

        public synchronized void add(IObservable observable) {
            if (this.pool == null) {
                this.pool = Lists.newArrayList();
            }
            this.pool.add(observable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            pools.remove(this.realm);
            block3: while (true) {
                Collection<IObservable> toDrain;
                AutoReleasePool autoReleasePool = this;
                synchronized (autoReleasePool) {
                    toDrain = this.pool;
                    this.pool = null;
                }
                if (toDrain == null) break;
                Iterator iterator = toDrain.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block3;
                    IObservable next = (IObservable)iterator.next();
                    Util.release(next);
                }
                break;
            }
        }

        private final class ReleaseRunnable
        implements Runnable {
            private ReleaseRunnable() {
            }

            @Override
            public void run() {
                AutoReleasePool.this.release();
            }
        }
    }

    public static class Support {
        private final IObservable observable;
        private final AtomicInteger refCount = new AtomicInteger();

        public Support(IObservable observable) {
            this.observable = observable;
        }

        public void retain() {
            this.refCount.incrementAndGet();
        }

        public void release() {
            if (this.refCount.decrementAndGet() <= 0 && !this.observable.isDisposed()) {
                this.observable.dispose();
            }
        }

        public void autorelease() {
            AutoReleasePool.get(this.observable.getRealm()).add(this.observable);
        }
    }

    public static final class Util {
        private static final Map<IObservable, WeakRefCount> adapters = new MapMaker().concurrencyLevel(1).weakKeys().makeMap();

        private Util() {
        }

        public static <T extends IObservable> T retain(T observable) {
            if (observable instanceof ReferenceCountedObservable) {
                ((ReferenceCountedObservable)observable).retain();
            } else if (!observable.isDisposed()) {
                WeakRefCount adapter = Util.adapt(observable, true);
                adapter.retain();
            }
            return observable;
        }

        public static <T extends IObservable> T release(T observable) {
            WeakRefCount adapter;
            if (observable instanceof ReferenceCountedObservable) {
                ((ReferenceCountedObservable)observable).release();
            } else if (!observable.isDisposed() && (adapter = Util.adapt(observable, false)) != null) {
                adapter.release();
            }
            return observable;
        }

        public static <T extends IObservable> T autorelease(T observable) {
            WeakRefCount adapter;
            if (observable instanceof ReferenceCountedObservable) {
                ((ReferenceCountedObservable)observable).autorelease();
            } else if (!observable.isDisposed() && (adapter = Util.adapt(observable, false)) != null) {
                adapter.autorelease();
            }
            return observable;
        }

        private static WeakRefCount adapt(IObservable observable, boolean create) {
            WeakRefCount result = adapters.get(observable);
            if (result == null && create) {
                result = new WeakRefCount(observable);
                adapters.put(observable, result);
            }
            return result;
        }

        private static final class WeakRefCount
        extends WeakReference<IObservable>
        implements IDisposeListener {
            private final AtomicInteger refCount = new AtomicInteger();

            WeakRefCount(IObservable observable) {
                super(observable);
                observable.addDisposeListener((IDisposeListener)this);
            }

            public void retain() {
                this.refCount.incrementAndGet();
            }

            public void release() {
                IObservable observable;
                if (this.refCount.decrementAndGet() <= 0 && (observable = (IObservable)this.get()) != null) {
                    if (!observable.isDisposed()) {
                        observable.dispose();
                    }
                    this.clear();
                }
            }

            public void autorelease() {
                IObservable observable = (IObservable)this.get();
                if (observable != null) {
                    AutoReleasePool.get(observable.getRealm()).add(observable);
                }
            }

            public void handleDispose(DisposeEvent event) {
                if (event.getObservable() == this.get()) {
                    this.clear();
                }
            }
        }
    }

    public static abstract class Value<T>
    extends AbstractObservableValue<T>
    implements ReferenceCountedObservable {
        private final Support refCount = new Support(this);

        public Value() {
        }

        public Value(Realm realm) {
            super(realm);
        }

        @Override
        public void retain() {
            this.refCount.retain();
        }

        @Override
        public void release() {
            this.refCount.release();
        }

        @Override
        public void autorelease() {
            this.refCount.autorelease();
        }
    }
}

