/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.fillhandle.action;

import java.util.Date;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.copy.InternalCellClipboard;
import org.eclipse.nebula.widgets.nattable.fillhandle.action.FillHandleDragMode;
import org.eclipse.nebula.widgets.nattable.fillhandle.command.FillHandlePasteCommand;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.papyrus.infra.nattable.fillhandle.command.PapyrusFillHandlePasteCommand;
import org.eclipse.papyrus.infra.nattable.fillhandle.utils.PapyrusFillHandleUtils;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class PapyrusFillHandleDragMode
extends FillHandleDragMode {
    protected boolean createDoubleSeriesMenu = false;

    public PapyrusFillHandleDragMode(SelectionLayer selectionLayer, InternalCellClipboard clipboard) {
        super(selectionLayer, clipboard);
    }

    protected void openMenu(NatTable natTable) {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
            this.menu = null;
        }
        this.menu = new Menu((Control)natTable);
        MenuItem copyItem = new MenuItem(this.menu, 8);
        copyItem.setText(Messages.PapyrusFillHandleDragMode_CopyCommandName);
        this.setPasteSelectionListener(copyItem, natTable, FillHandlePasteCommand.FillHandleOperation.COPY, false, false);
        String firstSeriesMenuName = null;
        String secondSeriesMenuName = null;
        if (this.createDoubleSeriesMenu) {
            firstSeriesMenuName = Messages.PapyrusFillHandleDragMode_IncrementPrefixCommandName;
            secondSeriesMenuName = Messages.PapyrusFillHandleDragMode_DecrementPrefixCommandName;
        } else {
            firstSeriesMenuName = Messages.PapyrusFillHandleDragMode_IncrementCommandName;
            secondSeriesMenuName = Messages.PapyrusFillHandleDragMode_DecrementCommandName;
        }
        MenuItem incrementItem = new MenuItem(this.menu, 8);
        incrementItem.setText(firstSeriesMenuName);
        this.setPasteSelectionListener(incrementItem, natTable, FillHandlePasteCommand.FillHandleOperation.SERIES, true, true);
        MenuItem decrementItem = new MenuItem(this.menu, 8);
        decrementItem.setText(secondSeriesMenuName);
        this.setPasteSelectionListener(decrementItem, natTable, FillHandlePasteCommand.FillHandleOperation.SERIES, false, true);
        if (this.createDoubleSeriesMenu) {
            MenuItem incrementSuffixItem = new MenuItem(this.menu, 8);
            incrementSuffixItem.setText(Messages.PapyrusFillHandleDragMode_IncrementSuffixCommandName);
            this.setPasteSelectionListener(incrementSuffixItem, natTable, FillHandlePasteCommand.FillHandleOperation.SERIES, true, false);
            MenuItem decrementSuffixItem = new MenuItem(this.menu, 8);
            decrementSuffixItem.setText(Messages.PapyrusFillHandleDragMode_DecrementSuffixCommandName);
            this.setPasteSelectionListener(decrementSuffixItem, natTable, FillHandlePasteCommand.FillHandleOperation.SERIES, false, false);
        }
        natTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PapyrusFillHandleDragMode.this.menu.dispose();
            }
        });
        this.menu.setVisible(true);
    }

    protected void setPasteSelectionListener(MenuItem menuItem, final NatTable natTable, final FillHandlePasteCommand.FillHandleOperation operation, final boolean isIncrement, final boolean isPrefix) {
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                natTable.doCommand((ILayerCommand)new PapyrusFillHandlePasteCommand(operation, PapyrusFillHandleDragMode.this.direction, natTable.getConfigRegistry(), isIncrement, isPrefix));
                PapyrusFillHandleDragMode.this.reset(natTable);
            }
        });
    }

    protected boolean showMenu(NatTable natTable) {
        boolean result = false;
        this.createDoubleSeriesMenu = false;
        String templateString = "";
        if (this.clipboard != null && this.clipboard.getCopiedCells() != null) {
            ILayerCell[][] copiedCells = this.clipboard.getCopiedCells();
            result = true;
            Class<?> type = null;
            int cellsIndex = 0;
            while (cellsIndex < copiedCells.length && result) {
                ILayerCell[] cells = copiedCells[cellsIndex];
                int cellIndex = 0;
                while (cellIndex < cells.length && result) {
                    String stringValue;
                    ILayerCell cell = cells[cellIndex];
                    if (cell.getDataValue() == null) {
                        result = false;
                    } else if (type == null) {
                        type = cell.getDataValue().getClass();
                        if (String.class.isAssignableFrom(type)) {
                            stringValue = (String)cell.getDataValue();
                            String templateStringWithoutBeginningNumber = PapyrusFillHandleUtils.getTemplateWithoutBeginningNumber(stringValue);
                            String templateStringWithoutEndingNumber = PapyrusFillHandleUtils.getTemplateWithoutEndingNumber(stringValue);
                            String beginningNumberString = stringValue.replace(templateStringWithoutBeginningNumber, "");
                            String endingNumberString = stringValue.replace(templateStringWithoutEndingNumber, "");
                            if (!beginningNumberString.isEmpty() || !endingNumberString.isEmpty()) {
                                boolean isBeginningByNumber = PapyrusFillHandleUtils.isBeginningByNumber(stringValue, beginningNumberString);
                                boolean isEndingByNumber = PapyrusFillHandleUtils.isEndingByNumber(stringValue, endingNumberString);
                                this.createDoubleSeriesMenu = isBeginningByNumber && isEndingByNumber;
                            } else {
                                result = false;
                            }
                        } else if (!Number.class.isAssignableFrom(type) && !Date.class.isAssignableFrom(type)) {
                            result = false;
                        }
                    } else if (type != cell.getDataValue().getClass()) {
                        result = false;
                    } else if (String.class.isAssignableFrom(type)) {
                        stringValue = (String)cell.getDataValue();
                        String currentTemplateString = PapyrusFillHandleUtils.getTemplateString(stringValue);
                        String number = stringValue.replace(currentTemplateString, "");
                        result = templateString.equals(currentTemplateString) && !number.isEmpty();
                    }
                    ++cellIndex;
                }
                ++cellsIndex;
            }
        }
        return result;
    }
}

