/*****************************************************************************
 * Copyright (c) 2007, 2009 Borland Software Corporation
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 * Alexander Shatalin (Borland) - initial API and implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * 
 *****************************************************************************/
package aspects.xpt.diagram.editpolicies

import com.google.inject.Inject
import com.google.inject.Singleton
import metamodel.MetaModel
import org.eclipse.gmf.codegen.gmfgen.GenNode
import org.eclipse.gmf.codegen.gmfgen.TypeModelFacet
import org.eclipse.papyrus.papyrusgmfgenextension.GenerateUsingElementTypeCreationCommand
import xpt.Common
import xpt.providers.ElementTypes

@Singleton class childContainerCreateCommand extends xpt.diagram.editpolicies.childContainerCreateCommand{
	
	@Inject extension Common;
	
	@Inject extension ElementTypes;
	
	@Inject extension MetaModel;

 
 	override CharSequence childContainerCreateCommand(Iterable<? extends GenNode> nodes) '''
	«IF ! nodes.empty»

	«generatedMemberComment()»
	protected org.eclipse.gef.commands.Command getCreateCommand(org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest req) {
				org.eclipse.gmf.runtime.emf.type.core.IElementType requestElementType = req.getElementType();
		if(requestElementType == null) {
			return super.getCreateCommand(req);
		}


	«FOR n : nodes»
		«IF !n.sansDomain»
			«childNodeCreateCommand(n.modelFacet, n)»
		«ENDIF»
	«ENDFOR»
		return super.getCreateCommand(req);
	}
	«ENDIF»
	'''

	def childNodeCreateCommand(TypeModelFacet it,GenNode node)'''
	if («accessElementType(node)» == requestElementType) {
		«IF it.eResource.allContents.filter(typeof (GenerateUsingElementTypeCreationCommand)).size>0»
		// adjust the containment feature
		org.eclipse.emf.ecore.EReference containmentFeature = «MetaFeature(it.childMetaFeature)»;
		req.setContainmentFeature(containmentFeature);
		«ENDIF»

		«IF it.eResource.allContents.filter(typeof (GenerateUsingElementTypeCreationCommand)).size>0»
		return getGEFWrapper(getSemanticCreationCommand(req));
		«ELSE»
		return getGEFWrapper(new «node.getCreateCommandQualifiedClassName()»(req, org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils.getDiagramFrom(getHost())));
		«ENDIF»
		
	}
	'''

}