/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.stereotype.migration.commands;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.commands.RemoveEAnnotationCommand;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayUtil;
import org.eclipse.papyrus.uml.diagram.common.stereotype.migration.StereotypeEAnnotationLabelMigration;
import org.eclipse.papyrus.uml.diagram.common.stereotype.migration.StereotypeEAnnotationNestedMigration;
import org.eclipse.papyrus.uml.diagram.common.stereotype.migration.StereotypeEAnnotationPropertiesMigration;
import org.eclipse.papyrus.uml.diagram.common.stereotype.migration.StereotypeMigrationHelper;
import org.eclipse.papyrus.uml.diagram.common.util.CommandUtil;

public class StereotypesMigrationCommand
extends AbstractTransactionalCommand {
    private Diagram diagram;
    protected StereotypeMigrationHelper migrationHelper = StereotypeMigrationHelper.getInstance();
    protected StereotypeDisplayUtil helper = StereotypeDisplayUtil.getInstance();

    public StereotypesMigrationCommand(TransactionalEditingDomain domain, Diagram diagram) {
        super(domain, "Stereotypes Migration", null);
        this.diagram = diagram;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) {
        TreeIterator allContentIterator = this.diagram.eAllContents();
        ArrayList<View> viewsToClean = new ArrayList<View>();
        ArrayList<View> viewsWithCommentToDelete = new ArrayList<View>();
        while (allContentIterator.hasNext()) {
            EObject eObject = (EObject)allContentIterator.next();
            if (!(eObject instanceof View)) continue;
            View view = (View)eObject;
            if (!StereotypeMigrationHelper.getInstance().hasStereotypeEAnnotation(view)) continue;
            if (view.getElement() != null) {
                String appliedStereotypesPropertiesLocalization = this.migrationHelper.getAppliedStereotypesPropertiesLocalization((EModelElement)view);
                StereotypeEAnnotationLabelMigration labelMigration = new StereotypeEAnnotationLabelMigration(view);
                labelMigration.activate();
                if (view instanceof BasicCompartment) {
                    StereotypeEAnnotationNestedMigration nestedMigration = new StereotypeEAnnotationNestedMigration(view);
                    nestedMigration.activate();
                } else {
                    StereotypeEAnnotationPropertiesMigration propertiesMigration = new StereotypeEAnnotationPropertiesMigration(view);
                    propertiesMigration.activate();
                }
                viewsToClean.add(view);
                if (!"Comment".equals(appliedStereotypesPropertiesLocalization)) continue;
                viewsWithCommentToDelete.add(view);
                continue;
            }
            if (!view.getType().equals("AppliedStereotypesComment")) continue;
            StereotypeEAnnotationNestedMigration nestedMigration = new StereotypeEAnnotationNestedMigration(view);
            nestedMigration.activate();
        }
        for (View view : viewsWithCommentToDelete) {
            this.deleteOldComment(view);
        }
        for (View view : viewsToClean) {
            this.cleanEAnnotation(view);
        }
        return CommandResult.newOKCommandResult();
    }

    private void deleteOldComment(View view) {
        Edge oldLink;
        View oldComment = this.migrationHelper.getOldStereotypeComment(view);
        if (oldComment != null) {
            DeleteCommand deleteComment = new DeleteCommand(oldComment);
            CommandUtil.executeUnsafeCommand((ICommand)deleteComment, (Object)view);
        }
        if ((oldLink = this.migrationHelper.getOldStereotypeLinkComment(view)) != null) {
            DeleteCommand deleteLink = new DeleteCommand((View)oldLink);
            CommandUtil.executeUnsafeCommand((ICommand)deleteLink, (Object)view);
        }
    }

    private void cleanEAnnotation(View view) {
        EObject container;
        RemoveEAnnotationCommand command;
        TransactionalEditingDomain resolveEditingDomain = CommandUtil.resolveEditingDomain(view);
        EAnnotation eAnnotation = this.migrationHelper.getStereotypeEAnnotation((EModelElement)view);
        if (eAnnotation != null && eAnnotation.getDetails().isEmpty()) {
            command = new RemoveEAnnotationCommand(resolveEditingDomain, (EModelElement)view, (EModelElement)eAnnotation);
            CommandUtil.executeUnsafeCommand((Command)command, (Object)view);
        }
        if (eAnnotation != null && !this.helper.hasStereotypeViews(view)) {
            command = new RemoveEAnnotationCommand(resolveEditingDomain, (EModelElement)view, (EModelElement)eAnnotation);
            CommandUtil.executeUnsafeCommand((Command)command, (Object)view);
        }
        if ((container = view.eContainer()) instanceof View) {
            View containerView = (View)container;
            for (Object sibiling : containerView.getChildren()) {
                if (!this.migrationHelper.isOldComment(sibiling) || !this.migrationHelper.isOrphanComment((View)sibiling)) continue;
                DeleteCommand deleteComment = new DeleteCommand((View)sibiling);
                CommandUtil.executeUnsafeCommand((ICommand)deleteComment, sibiling);
            }
        }
    }
}

