/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.custom.policies;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.papyrus.uml.diagram.clazz.custom.policies.AbstractCustomLabelEditPolicy;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.InformationFlowConveyedLabelEditPart;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.uml2.uml.InformationFlow;
import org.eclipse.uml2.uml.NamedElement;

public class InformationFlowCustomLabelEditPolicy
extends AbstractCustomLabelEditPolicy {
    public static final String SPECIFIC_NAME_LABEL_POLICY = "SpecificNameLabelEditPolicy";
    public static final int ADD_CONVEYED_CLASSIFIER = 3;
    public static final int REMOVE_CONVEYED_CLASSIFER = 4;
    public static final int CHANGE_NAME_OF_A_CONVOYED_CLASSIFIER = 1;

    @Override
    protected void addAdditionalListeners() {
        if (this.getUMLElement() instanceof InformationFlow) {
            EList conveyedClassifiers = ((InformationFlow)this.getUMLElement()).getConveyeds();
            int i = 0;
            while (i < conveyedClassifiers.size()) {
                this.getDiagramEventBroker().addNotificationListener((EObject)conveyedClassifiers.get(i), (NotificationListener)this);
                ++i;
            }
        }
    }

    @Override
    public void refreshDisplay() {
        this.refreshNameDisplay();
    }

    @Override
    protected void removeAdditionalListeners() {
        if (this.getUMLElement() instanceof InformationFlow) {
            EList conveyedClassifiers = ((InformationFlow)this.getUMLElement()).getConveyeds();
            int i = 0;
            while (i < conveyedClassifiers.size()) {
                this.getDiagramEventBroker().removeNotificationListener((EObject)conveyedClassifiers.get(i), (NotificationListener)this);
                ++i;
            }
        }
    }

    protected void refreshNameDisplay() {
        if (this.getHost() instanceof InformationFlowConveyedLabelEditPart) {
            ((InformationFlowConveyedLabelEditPart)this.getHost()).setLabelText(this.nameToDisplay());
        }
    }

    public void notifyChanged(Notification notification) {
        int eventType = notification.getEventType();
        if (notification.getNotifier() instanceof InformationFlow) {
            switch (eventType) {
                case 3: {
                    this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this);
                    this.refreshDisplay();
                    break;
                }
                case 4: {
                    this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this);
                    this.refreshDisplay();
                }
            }
        }
        if (eventType == 1) {
            this.refreshDisplay();
        }
    }

    public String nameToDisplay() {
        String name = "";
        if (this.getUMLElement() instanceof InformationFlow) {
            EList classes = ((InformationFlow)this.getUMLElement()).getConveyeds();
            int i = 0;
            while (i < classes.size()) {
                name = String.valueOf(name) + UMLLabelInternationalization.getInstance().getLabel((NamedElement)classes.get(i));
                if (i != classes.size() - 1) {
                    name = String.valueOf(name) + ", ";
                }
                ++i;
            }
        }
        return name;
    }
}

