/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.policies;

import java.util.Collection;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.ContainerNodeDescriptorRegistry;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.IContainerNodeDescriptor;
import org.eclipse.papyrus.uml.diagram.activity.edit.policies.CustomDiagramDragDropEditPolicy;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Pin;

public class ActivityGroupCustomDragAndDropEditPolicy
extends CustomDiagramDragDropEditPolicy {
    protected IUndoableOperation getDropObjectCommand(DropObjectsRequest dropRequest, EObject droppedObject) {
        Point location = dropRequest.getLocation().getCopy();
        EditPart hostForDroppedObject = droppedObject instanceof Pin ? this.getHost().getParent() : this.getHost();
        String nodeVISUALID = this.getNodeVisualID(((IGraphicalEditPart)hostForDroppedObject).getNotationView(), droppedObject);
        String linkVISUALID = this.getLinkWithClassVisualID(droppedObject);
        if (this.getSpecificDrop().contains(nodeVISUALID) || this.getSpecificDrop().contains(linkVISUALID)) {
            Command specificDropCommand = this.getSpecificDropCommand(dropRequest, (Element)droppedObject, nodeVISUALID, linkVISUALID);
            CompositeCommand cc = new CompositeCommand("Drop command");
            cc.compose((IUndoableOperation)new CommandProxy(specificDropCommand));
            if (this.isCopy(dropRequest)) {
                CompoundCommand specificDropCompoundCommand;
                ICommandProxy cp;
                if (specificDropCommand instanceof ICommandProxy) {
                    ICommandProxy specificDropCommandProxy = (ICommandProxy)specificDropCommand;
                    this.createDeferredCommandWithCommandResult(droppedObject, cc, specificDropCommandProxy);
                } else if (specificDropCommand instanceof CompoundCommand && (cp = this.getCommandProxyFromCompoundCommand(specificDropCompoundCommand = (CompoundCommand)specificDropCommand)) != null) {
                    this.createDeferredCommandWithCommandResult(droppedObject, cc, cp);
                }
            }
            return cc;
        }
        if (linkVISUALID == null && nodeVISUALID != null) {
            EObject graphicalParent = ((GraphicalEditPart)this.getHost()).resolveSemanticElement();
            IContainerNodeDescriptor descriptor = ContainerNodeDescriptorRegistry.getInstance().getContainerNodeDescriptor(this.getContainerEClass());
            if (graphicalParent instanceof Element) {
                if (descriptor.canIBeModelParentOf(droppedObject.eClass())) {
                    if (droppedObject.eContainer() != null && !droppedObject.eContainer().equals(this.getHostObject())) {
                        return UnexecutableCommand.INSTANCE;
                    }
                    return this.getDefaultDropNodeCommand(hostForDroppedObject, nodeVISUALID, location, droppedObject, dropRequest);
                }
                if (descriptor.canIBeGraphicalParentOf(droppedObject.eClass())) {
                    return this.getDefaultDropNodeCommand(hostForDroppedObject, nodeVISUALID, location, droppedObject, dropRequest);
                }
            }
            return UnexecutableCommand.INSTANCE;
        }
        if (linkVISUALID != null) {
            Collection sources = this.linkmappingHelper.getSource((Element)droppedObject);
            Collection targets = this.linkmappingHelper.getTarget((Element)droppedObject);
            if (sources.size() == 0 || targets.size() == 0) {
                return UnexecutableCommand.INSTANCE;
            }
            Element source = (Element)sources.toArray()[0];
            Element target = (Element)targets.toArray()[0];
            CompositeCommand cc = new CompositeCommand("Add Link");
            this.dropBinaryLink(cc, source, target, linkVISUALID, location, (Element)droppedObject);
            return cc;
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected EClass getContainerEClass() {
        IGraphicalEditPart part;
        EObject element;
        EditPart editPart = this.getHost();
        if (editPart instanceof IGraphicalEditPart && (element = (part = (IGraphicalEditPart)editPart).resolveSemanticElement()) != null) {
            return element.eClass();
        }
        return null;
    }
}

