/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.handler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.nebula.widgets.nattable.util.ArrayUtil;
import org.eclipse.papyrus.infra.nattable.handler.AbstractMergeHandler;
import org.eclipse.papyrus.infra.nattable.layerstack.BodyLayerStack;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.BooleanValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestyleFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.ui.handlers.HandlerUtil;

public class MergeSelectedRowsHandler
extends AbstractMergeHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        CompositeCommand mergeCommand = new CompositeCommand("Merge/UnMerge the cells in each selected rows");
        TransactionalEditingDomain tableDomain = this.getTableEditingDomain();
        BodyLayerStack bodyLayerStack = this.getCurrentNattableModelManager().getBodyLayerStack();
        String commandId = event.getCommand().getId();
        boolean isMerged = HandlerUtil.toggleCommandState((Command)event.getCommand());
        INattableModelManager manager = this.getCurrentNattableModelManager();
        int[] selectedRows = bodyLayerStack.getSelectionLayer().getFullySelectedRowPositions();
        List selectedRs = ArrayUtil.asIntegerList((int[])selectedRows);
        int idex = 0;
        ArrayList<Integer> mergedRows = new ArrayList<Integer>();
        for (Object currentObject : manager.getRowElementsList()) {
            if (!(currentObject instanceof IAxis)) continue;
            IAxis currentAxis = (IAxis)currentObject;
            BooleanValueStyle axisToMerge = (BooleanValueStyle)currentAxis.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "mergeInSelectedRows");
            if (axisToMerge != null && axisToMerge.isBooleanValue()) {
                mergedRows.add(idex);
            }
            ++idex;
        }
        if (!isMerged || isMerged && !selectedRs.equals(mergedRows)) {
            ArrayList<IAxis> selectedRowAxis = new ArrayList<IAxis>();
            int[] nArray = selectedRows;
            int axisToMerge = selectedRows.length;
            int n = 0;
            while (n < axisToMerge) {
                IAxis currentRowIAxis;
                int index = nArray[n];
                Object currentRowObject = this.getCurrentNattableModelManager().getRowElement(index);
                if (currentRowObject instanceof IAxis && (currentRowIAxis = (IAxis)currentRowObject).eContainer() != null) {
                    SetValueCommand mergeRowCommand;
                    selectedRowAxis.add(currentRowIAxis);
                    BooleanValueStyle isSelected = (BooleanValueStyle)currentRowIAxis.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "mergeInSelectedRows");
                    if (isSelected != null) {
                        SetRequest mergeRowRequest = new SetRequest(tableDomain, (EObject)isSelected, (EStructuralFeature)NattablestylePackage.eINSTANCE.getBooleanValueStyle_BooleanValue(), (Object)true);
                        mergeRowCommand = new SetValueCommand(mergeRowRequest);
                        mergeCommand.add((IUndoableOperation)mergeRowCommand);
                    } else {
                        isSelected = NattablestyleFactory.eINSTANCE.createBooleanValueStyle();
                        isSelected.setBooleanValue(true);
                        isSelected.setName("mergeInSelectedRows");
                        SetRequest initRowMergeRequest = new SetRequest(tableDomain, (EObject)currentRowIAxis, (EStructuralFeature)NattablestylePackage.eINSTANCE.getStyledElement_Styles(), (Object)isSelected);
                        mergeRowCommand = new SetValueCommand(initRowMergeRequest);
                        mergeCommand.add((IUndoableOperation)mergeRowCommand);
                    }
                }
                ++n;
            }
            if (!selectedRs.equals(mergedRows)) {
                Iterator iterator = mergedRows.iterator();
                while (iterator.hasNext()) {
                    IAxis toUnMerge;
                    BooleanValueStyle isSelected;
                    int sel = (Integer)iterator.next();
                    if (selectedRs.contains(sel) || !(manager.getRowElement(sel) instanceof IAxis) || (isSelected = (BooleanValueStyle)(toUnMerge = (IAxis)manager.getRowElement(sel)).getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "mergeInSelectedRows")) == null) continue;
                    SetRequest mergeRowRequest = new SetRequest(tableDomain, (EObject)isSelected, (EStructuralFeature)NattablestylePackage.eINSTANCE.getBooleanValueStyle_BooleanValue(), (Object)false);
                    SetValueCommand mergeRowCommand = new SetValueCommand(mergeRowRequest);
                    mergeCommand.add((IUndoableOperation)mergeRowCommand);
                }
                if (selectedRs.size() == 0) {
                    this.updateAxisSpanBooleans(commandId, mergeCommand);
                }
            }
        } else {
            this.updateAxisSpanBooleans(commandId, mergeCommand);
        }
        this.executeMergeCommands(mergeCommand, tableDomain);
        return null;
    }
}

