/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.comparator;

import java.math.BigDecimal;
import java.util.Comparator;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;

public class DoubleFilterComparator
implements Comparator<Object> {
    private static DoubleFilterComparator singleton;

    public static final DoubleFilterComparator getInstance() {
        if (singleton == null) {
            singleton = new DoubleFilterComparator();
        }
        return singleton;
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 instanceof Double && o2 instanceof Double) {
            Double d1 = (Double)o1;
            Double d2 = (Double)o2;
            return d1.compareTo(d2);
        }
        if (!(o1 instanceof Double)) {
            return Integer.MIN_VALUE;
        }
        if (o1 instanceof Double) {
            Double d1 = (Double)o1;
            Double d2 = null;
            if (o2 instanceof Double) {
                if (TypeUtils.isDoubleValue((String)o2.toString())) {
                    d2 = new BigDecimal(o2.toString()).doubleValue();
                    return d1.compareTo(d2);
                }
                return Integer.MIN_VALUE;
            }
        }
        return Integer.MIN_VALUE;
    }
}

