/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CellEditorDeclaration implements Enumerator
{
    COLUMN(0, "COLUMN", "COLUMN"),
    ROW(1, "ROW", "ROW"),
    CELL(2, "CELL", "CELL");

    public static final int COLUMN_VALUE = 0;
    public static final int ROW_VALUE = 1;
    public static final int CELL_VALUE = 2;
    private static final CellEditorDeclaration[] VALUES_ARRAY;
    public static final List<CellEditorDeclaration> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CellEditorDeclaration[]{COLUMN, ROW, CELL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CellEditorDeclaration get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CellEditorDeclaration result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CellEditorDeclaration getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CellEditorDeclaration result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CellEditorDeclaration get(int value) {
        switch (value) {
            case 0: {
                return COLUMN;
            }
            case 1: {
                return ROW;
            }
            case 2: {
                return CELL;
            }
        }
        return null;
    }

    private CellEditorDeclaration(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

