/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.properties.constraint;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.papyrus.infra.constraints.ConstraintDescriptor;
import org.eclipse.papyrus.infra.constraints.DisplayUnit;
import org.eclipse.papyrus.infra.constraints.constraints.Constraint;
import org.eclipse.papyrus.infra.gmfdiag.properties.Activator;
import org.eclipse.papyrus.infra.gmfdiag.properties.extension.StyleHandlerManager;
import org.eclipse.papyrus.infra.gmfdiag.properties.modelelement.StyleHandlerProvider;

public class AppearanceConstraint
implements Constraint {
    private final List<Constraint> constraints = new LinkedList<Constraint>();
    private DisplayUnit display;
    private ConstraintDescriptor descriptor;

    public AppearanceConstraint() {
        for (StyleHandlerProvider provider : StyleHandlerManager.instance.getStyleHandlerProviders()) {
            try {
                Constraint constraint = provider.createConstraint();
                if (constraint == null) {
                    Activator.log.warn("StyleHandlerProvider " + provider.getClass().getName() + " provided an invalid Constraint");
                    continue;
                }
                this.constraints.add(constraint);
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
            }
        }
    }

    public boolean overrides(Constraint constraint) {
        return false;
    }

    public boolean match(Collection<?> selection) {
        for (Constraint constraint : this.constraints) {
            if (!constraint.match(selection)) continue;
            return true;
        }
        return false;
    }

    public void setConstraintDescriptor(ConstraintDescriptor descriptor) {
        this.descriptor = descriptor;
        this.display = this.getDisplay(descriptor);
        for (Constraint constraint : this.constraints) {
            try {
                constraint.setConstraintDescriptor(descriptor);
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
            }
        }
    }

    public DisplayUnit getDisplayUnit() {
        return this.display;
    }

    private DisplayUnit getDisplay(ConstraintDescriptor descriptor) {
        if (descriptor.getDisplay() == null && descriptor.eContainer() instanceof ConstraintDescriptor) {
            return this.getDisplay((ConstraintDescriptor)descriptor.eContainer());
        }
        return descriptor.getDisplay();
    }

    public ConstraintDescriptor getDescriptor() {
        return this.descriptor;
    }
}

