/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.AspectCreationEntry;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.AspectUnspecifiedTypeConnectionTool;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.AspectUnspecifiedTypeCreationTool;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.DrawerConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.ElementDescriptor;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.IconDescriptor;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.PaletteConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.PaletteconfigurationFactory;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.PaletteconfigurationPackage;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.ToolConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.ToolKind;
import org.eclipse.papyrus.infra.types.AbstractAdviceBindingConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypesConfigurationsFactory;
import org.eclipse.papyrus.infra.types.ElementTypesConfigurationsPackage;
import org.eclipse.papyrus.infra.types.SpecializationTypeConfiguration;
import org.eclipse.papyrus.infra.types.core.IConfiguredHintedElementType;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.swt.graphics.Image;

public class CreatePaletteItemUtil {
    private static final String DRAWER_DEFAULT_LABEL = "Default";
    private static final String URL_IMAGE_DESCRIPTOR_BEGIN = "URLImageDescriptor(";

    private CreatePaletteItemUtil() {
    }

    public static ToolConfiguration createToolConfiguration(PaletteEntry entry, ResourceSet resourceSet) {
        ToolConfiguration tool = PaletteconfigurationFactory.eINSTANCE.createToolConfiguration();
        tool.setLabel(entry.getLabel());
        String toolIdendtifier = CreatePaletteItemUtil.generateID(entry.getId());
        tool.setId(toolIdendtifier);
        tool.setDescription(entry.getDescription());
        tool.setIcon(CreatePaletteItemUtil.createIconDescriptorFromPaletteEntry(entry));
        tool.setKind(CreatePaletteItemUtil.getKindFromPaletteEntry(entry));
        return tool;
    }

    public static Command createElementTypesElement(EditingDomain domain, ToolEntry entry, ToolConfiguration tool) {
        CompoundCommand cc = new CompoundCommand();
        ResourceSet resourceSet = domain.getResourceSet();
        String toolIdendtifier = tool.getId();
        SpecializationTypeConfiguration semanticSpecializedType = CreatePaletteItemUtil.createSemanticSpecializedType(toolIdendtifier, (PaletteEntry)entry, resourceSet);
        AddCommand setSemCommand = new AddCommand(domain, (EObject)CreatePaletteItemUtil.getSemanticElementTypeModel(resourceSet), (EStructuralFeature)ElementTypesConfigurationsPackage.Literals.ELEMENT_TYPE_SET_CONFIGURATION__ELEMENT_TYPE_CONFIGURATIONS, (Object)semanticSpecializedType);
        cc.append((Command)setSemCommand);
        if (semanticSpecializedType != null) {
            List<SpecializationTypeConfiguration> uiSpecializedTypes = CreatePaletteItemUtil.createUISpecializedTypes(semanticSpecializedType, (PaletteEntry)entry, resourceSet);
            AddCommand setuiCommand = new AddCommand(domain, (EObject)CreatePaletteItemUtil.getUIElementTypeModel(resourceSet), (EStructuralFeature)ElementTypesConfigurationsPackage.Literals.ELEMENT_TYPE_SET_CONFIGURATION__ELEMENT_TYPE_CONFIGURATIONS, uiSpecializedTypes);
            cc.append((Command)setuiCommand);
            if (uiSpecializedTypes != null) {
                List advices;
                List<ElementDescriptor> paletteElementDescriptors = CreatePaletteItemUtil.createPaletteElementDescriptors(uiSpecializedTypes);
                AddCommand setpaletteCommand = new AddCommand(domain, (EObject)tool, (EStructuralFeature)PaletteconfigurationPackage.Literals.TOOL_CONFIGURATION__ELEMENT_DESCRIPTORS, paletteElementDescriptors);
                cc.append((Command)setpaletteCommand);
                if (entry instanceof AspectCreationEntry && (advices = (List)((AspectCreationEntry)entry).getAspectProperties("advicesToApply")) != null && !advices.isEmpty()) {
                    for (Object advice : advices) {
                        if (!(advice instanceof AbstractAdviceBindingConfiguration)) continue;
                        ((AbstractAdviceBindingConfiguration)advice).setTarget((ElementTypeConfiguration)semanticSpecializedType);
                        ((AbstractAdviceBindingConfiguration)advice).setIdentifier(String.valueOf(semanticSpecializedType.getIdentifier()) + "_ASAC");
                        AddCommand setAdviceCommand = new AddCommand(domain, (EObject)CreatePaletteItemUtil.getSemanticElementTypeModel(resourceSet), (EStructuralFeature)ElementTypesConfigurationsPackage.Literals.ELEMENT_TYPE_SET_CONFIGURATION__ADVICE_BINDINGS_CONFIGURATIONS, advice);
                        cc.append((Command)setAdviceCommand);
                    }
                }
            }
        }
        return cc;
    }

    protected static List<ElementDescriptor> createPaletteElementDescriptors(List<SpecializationTypeConfiguration> uiSpecializedTypes) {
        ArrayList<ElementDescriptor> descriptors = new ArrayList<ElementDescriptor>();
        for (SpecializationTypeConfiguration uiSpecializationType : uiSpecializedTypes) {
            ElementDescriptor descriptor = PaletteconfigurationFactory.eINSTANCE.createElementDescriptor();
            descriptor.setElementType((ElementTypeConfiguration)uiSpecializationType);
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    public static List<SpecializationTypeConfiguration> createUISpecializedTypes(SpecializationTypeConfiguration semanticSpecializedType, PaletteEntry entry, ResourceSet resourceSet) {
        Tool tool = ((ToolEntry)entry).createTool();
        List<IElementType> elementTypes = CreatePaletteItemUtil.getToolElementTypes(tool);
        ElementTypeSetConfiguration uiElementTypeModel = CreatePaletteItemUtil.getUIElementTypeModel(resourceSet);
        ArrayList<SpecializationTypeConfiguration> uiSpecializationTypes = new ArrayList<SpecializationTypeConfiguration>();
        if (elementTypes != null && uiElementTypeModel != null) {
            for (IElementType elementType : elementTypes) {
                if (!(elementType instanceof IConfiguredHintedElementType)) continue;
                uiSpecializationTypes.add(CreatePaletteItemUtil.createUISpecializedType(entry.getLabel(), uiElementTypeModel, semanticSpecializedType, (IConfiguredHintedElementType)elementType));
            }
        }
        return uiSpecializationTypes;
    }

    public static SpecializationTypeConfiguration createSemanticSpecializedType(String identifier, PaletteEntry paletteEntry, ResourceSet resourceSet) {
        IElementType toolSpecializedType;
        String name = paletteEntry.getLabel();
        SpecializationTypeConfiguration specializedType = null;
        if (paletteEntry instanceof ToolEntry && (toolSpecializedType = CreatePaletteItemUtil.getToolElementTypes(((ToolEntry)paletteEntry).createTool()).get(0)) instanceof IConfiguredHintedElementType) {
            String id = CreatePaletteItemUtil.getPaletteConfigurationModel(resourceSet).getId();
            StringBuilder newSpecializedTypeId = new StringBuilder();
            newSpecializedTypeId.append(id);
            newSpecializedTypeId.append(".");
            newSpecializedTypeId.append(identifier);
            List<ElementTypeConfiguration> elementTypeConfigurations = Arrays.asList(((IConfiguredHintedElementType)toolSpecializedType).getConfiguration());
            ElementTypeSetConfiguration semanticElementTypeModel = CreatePaletteItemUtil.getSemanticElementTypeModel(resourceSet);
            if (semanticElementTypeModel != null) {
                specializedType = CreatePaletteItemUtil.createSpecializedType(newSpecializedTypeId.toString(), name, elementTypeConfigurations);
            }
        }
        return specializedType;
    }

    public static SpecializationTypeConfiguration createSpecializedType(String identifier, String name, List<ElementTypeConfiguration> specializedTypes) {
        SpecializationTypeConfiguration semSpecializationType = ElementTypesConfigurationsFactory.eINSTANCE.createSpecializationTypeConfiguration();
        semSpecializationType.setIdentifier(identifier);
        semSpecializationType.setKind("org.eclipse.gmf.runtime.emf.type.core.IHintedType");
        semSpecializationType.setName(name);
        semSpecializationType.getSpecializedTypes().addAll(specializedTypes);
        return semSpecializationType;
    }

    public static PaletteConfiguration createInitialModel() {
        PaletteConfiguration palette = PaletteconfigurationFactory.eINSTANCE.createPaletteConfiguration();
        palette.setId(CreatePaletteItemUtil.generateInitPaletteIDValue());
        DrawerConfiguration drawer = PaletteconfigurationFactory.eINSTANCE.createDrawerConfiguration();
        drawer.setLabel(DRAWER_DEFAULT_LABEL);
        drawer.setId(CreatePaletteItemUtil.generateID(DRAWER_DEFAULT_LABEL));
        palette.getDrawerConfigurations().add((Object)drawer);
        return palette;
    }

    public static String generateInitPaletteIDValue() {
        return CreatePaletteItemUtil.generateID(System.getProperty("user.name"));
    }

    public static SpecializationTypeConfiguration createUISpecializedType(String name, ElementTypeSetConfiguration uiElementTypeModel, SpecializationTypeConfiguration semanticSpecializedType, IConfiguredHintedElementType uiElementType) {
        String semanticHint = uiElementType.getSemanticHint();
        ArrayList<Object> elementTypes = new ArrayList<Object>();
        elementTypes.add(semanticSpecializedType);
        elementTypes.add(uiElementType.getConfiguration());
        SpecializationTypeConfiguration uiSpecializationType = null;
        EList elementTypeConfigurations = uiElementTypeModel.getElementTypeConfigurations();
        for (ElementTypeConfiguration elementTypeConfiguration : elementTypeConfigurations) {
            if (!(elementTypeConfiguration instanceof SpecializationTypeConfiguration)) continue;
            String hint = elementTypeConfiguration.getHint();
            EList specializedTypesID = ((SpecializationTypeConfiguration)elementTypeConfiguration).getSpecializedTypes();
            if (!hint.equals(semanticHint) || !specializedTypesID.containsAll(elementTypes) || !elementTypes.containsAll((Collection<?>)specializedTypesID)) continue;
            uiSpecializationType = (SpecializationTypeConfiguration)elementTypeConfiguration;
        }
        if (uiSpecializationType == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(semanticSpecializedType.getIdentifier());
            stringBuilder.append("_");
            stringBuilder.append(semanticHint);
            String newUISpecilizedTypeIdentifier = stringBuilder.toString();
            uiSpecializationType = ElementTypesConfigurationsFactory.eINSTANCE.createSpecializationTypeConfiguration();
            uiSpecializationType.setHint(semanticHint);
            uiSpecializationType.setIdentifier(newUISpecilizedTypeIdentifier);
            uiSpecializationType.setKind("org.eclipse.gmf.runtime.emf.type.core.IHintedType");
            uiSpecializationType.setName(name);
            uiSpecializationType.getSpecializedTypes().addAll(elementTypes);
        }
        return uiSpecializationType;
    }

    public static PaletteConfiguration getPaletteConfigurationModel(ResourceSet resourceSet) {
        EObject eObject;
        Resource resource;
        EList contents;
        PaletteConfiguration palette = null;
        Object object = resourceSet.getLoadOptions().get("resourcePalette");
        if (object instanceof Resource && !(contents = (resource = (Resource)object).getContents()).isEmpty() && (eObject = (EObject)contents.get(0)) instanceof PaletteConfiguration) {
            palette = (PaletteConfiguration)eObject;
        }
        return palette;
    }

    public static ElementTypeSetConfiguration getSemanticElementTypeModel(ResourceSet resourceSet) {
        EObject eObject;
        Resource resource;
        EList contents;
        ElementTypeSetConfiguration elementTypeSem = null;
        Object object = resourceSet.getLoadOptions().get("resourceElementTypeSemantic");
        if (object instanceof Resource && !(contents = (resource = (Resource)object).getContents()).isEmpty() && (eObject = (EObject)contents.get(0)) instanceof ElementTypeSetConfiguration) {
            elementTypeSem = (ElementTypeSetConfiguration)eObject;
        }
        return elementTypeSem;
    }

    public static ElementTypeSetConfiguration getUIElementTypeModel(ResourceSet resourceSet) {
        EObject eObject;
        Resource resource;
        EList contents;
        ElementTypeSetConfiguration elementTypeUI = null;
        Object object = resourceSet.getLoadOptions().get("resourceElementTypeUI");
        if (object instanceof Resource && !(contents = (resource = (Resource)object).getContents()).isEmpty() && (eObject = (EObject)contents.get(0)) instanceof ElementTypeSetConfiguration) {
            elementTypeUI = (ElementTypeSetConfiguration)eObject;
        }
        return elementTypeUI;
    }

    public static List<IElementType> getToolElementTypes(Tool tool) {
        List elementTypes = null;
        if (tool instanceof AspectUnspecifiedTypeCreationTool) {
            elementTypes = ((AspectUnspecifiedTypeCreationTool)tool).getElementTypes();
        } else if (tool instanceof AspectUnspecifiedTypeConnectionTool) {
            elementTypes = ((AspectUnspecifiedTypeConnectionTool)tool).getElementTypes();
        }
        return elementTypes;
    }

    public static ToolKind getKindFromPaletteEntry(PaletteEntry entry) {
        ToolKind kind = ToolKind.CREATION_TOOL;
        PaletteContainer parent = entry.getParent();
        if (parent == null && entry instanceof AspectCreationEntry) {
            parent = ((AspectCreationEntry)entry).getReferencedEntry().getParent();
        }
        if (parent != null) {
            if (parent.getLabel().contains("Edges")) {
                kind = ToolKind.CONNECTION_TOOL;
            } else if (parent.getLabel().contains("Nodes")) {
                kind = ToolKind.CREATION_TOOL;
            }
        }
        return kind;
    }

    public static IconDescriptor createIconDescriptorFromPaletteEntry(PaletteEntry entry) {
        String iconPath = entry.getSmallIcon().toString();
        IconDescriptor iconDescriptor = null;
        if (iconPath.startsWith(URL_IMAGE_DESCRIPTOR_BEGIN)) {
            iconPath = iconPath.substring(URL_IMAGE_DESCRIPTOR_BEGIN.length(), iconPath.length() - 1);
            iconDescriptor = PaletteconfigurationFactory.eINSTANCE.createIconDescriptor();
            iconDescriptor.setPluginID(Activator.retrieveBundleId((String)iconPath));
            iconDescriptor.setIconPath(Activator.retrieveLocalPath((String)iconPath));
        }
        return iconDescriptor;
    }

    public static Image iconDescriptorToImage(IconDescriptor icon) {
        ImageDescriptor imageDescriptor;
        Image image = null;
        if (icon != null && (imageDescriptor = Activator.getDefault().getImageDescriptor(icon.getPluginID(), icon.getIconPath())) != null) {
            image = imageDescriptor.createImage();
        }
        return image;
    }

    public static String generateID(String prefix) {
        StringBuffer id = new StringBuffer();
        id.append(prefix);
        id.append("_");
        id.append(System.currentTimeMillis());
        return id.toString();
    }
}

