/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.tree;

import ca.odell.glazedlists.TreeList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.tree.SortableTreeComparator;
import org.eclipse.papyrus.infra.nattable.manager.axis.CompositeTreeAxisManagerForEventList;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.utils.TableHelper;

public class DatumTreeFormat
implements TreeList.Format<ITreeItemAxis> {
    private Comparator<ITreeItemAxis> comparator = null;
    private CompositeTreeAxisManagerForEventList axisManager;
    private final ISortModel sortModel;

    public DatumTreeFormat(ISortModel sortModel) {
        this.sortModel = sortModel;
    }

    public void getPath(List<ITreeItemAxis> path, ITreeItemAxis element) {
        TableHelper.getPath(path, element);
    }

    public boolean allowsChildren(ITreeItemAxis element) {
        return true;
    }

    public final void setTreeComparatorProvider(CompositeTreeAxisManagerForEventList comparatorProvider) {
        this.axisManager = comparatorProvider;
    }

    public Comparator<ITreeItemAxis> getComparator(final int depth) {
        if (this.axisManager == null) {
            return null;
        }
        if (this.comparator == null) {
            this.comparator = new SortableTreeComparator((Comparator)new Comparator<ITreeItemAxis>(){

                @Override
                public int compare(ITreeItemAxis o1, ITreeItemAxis o2) {
                    return DatumTreeFormat.this.axisManager.compare(DatumTreeFormat.this.sortModel, depth, o1, o2);
                }
            }, this.sortModel);
        }
        return this.comparator;
    }
}

