/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.papyrus.infra.hyperlink.messages.Messages;
import org.eclipse.papyrus.infra.hyperlink.ui.AbstractHyperLinkTab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;

public abstract class AbstractHyperLinkManagerShell
extends TrayDialog {
    private TabFolder tabFolder = null;
    private ArrayList<AbstractHyperLinkTab> tabList = new ArrayList();

    public AbstractHyperLinkManagerShell(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public AbstractHyperLinkManagerShell(IShellProvider parentProvider) {
        super(parentProvider);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected TabFolder getTabFolder() {
        return this.tabFolder;
    }

    protected List<AbstractHyperLinkTab> getTabs() {
        return Collections.unmodifiableList(this.tabList);
    }

    protected void addTab(AbstractHyperLinkTab tab) {
        this.tabList.add(tab);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.AbstractHyperLinkManagerShell_HyperLink);
    }

    protected Control createDialogArea(Composite parent) {
        this.tabFolder = new TabFolder(parent, 128);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        AbstractHyperLinkManagerShell.applyDialogFont((Control)this.tabFolder);
        return this.tabFolder;
    }

    protected void cancelPressed() {
        this.tabList.clear();
        super.cancelPressed();
    }

    protected void okPressed() {
        this.saveDialogSettings();
        this.tabList.clear();
        super.okPressed();
    }

    protected void saveDialogSettings() {
    }
}

