/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.papyrusgmfgenextension.popupaction;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmf.codegen.gmfgen.ElementType;
import org.eclipse.gmf.codegen.gmfgen.GMFGenFactory;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.gmf.codegen.gmfgen.MetamodelType;
import org.eclipse.gmf.codegen.gmfgen.SpecializationType;
import org.eclipse.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.papyrusgmfgenextension.popupaction.Action;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;

public class UpdateElementTypeToMatchGenericType
extends Action {
    private static final String GENERIC_UML_GMFGEN = "GenericUML.gmfgen";
    private static final String ORG_ECLIPSE_PAPYRUS_UML = "org.eclipse.papyrus.uml.";
    public static final String GEN_CLASS_RT_CLASS = "Node";
    public static final String GEN_CLASS_FACET_META_FEATURE = "NamedElement";
    public static final String GEN_FEATURE_FACET_META_FEATURE = "name";
    public static final String URI_NOTATION_GENMODEL = "org.eclipse.gmf.runtime.notation/model/notation.genmodel";
    public static final String URI_UML_GENMODEL = "org.eclipse.uml2.uml/model/UML.genmodel";

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        for (EObject eObject : this.getSelectedEObject()) {
            GenCommonBase commonBase;
            MetamodelType type;
            EObject object;
            TreeIterator genericTypes;
            EClass eClass;
            SpecializationType newType;
            String displayName;
            String id;
            GenClass metaclass;
            Resource genericTypeResource;
            if (eObject instanceof SpecializationType) {
                SpecializationType specializationType = (SpecializationType)eObject;
                genericTypeResource = this.getGenericTypeResource(specializationType.eResource().getResourceSet());
                if (genericTypeResource == null) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"no GenericUML.gmfgen resource has been found.");
                    return;
                }
                metaclass = specializationType.getMetamodelType().getMetaClass();
                id = specializationType.getUniqueIdentifier();
                displayName = specializationType.getDisplayName();
                if (metaclass == null) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"metaclass is null");
                    continue;
                }
                newType = GMFGenFactory.eINSTANCE.createSpecializationType();
                newType.setUniqueIdentifier(id);
                newType.setDefinedExternally(false);
                newType.setDisplayName(displayName);
                eClass = metaclass.getEcoreClass();
                genericTypes = genericTypeResource.getAllContents();
                while (genericTypes.hasNext()) {
                    object = (EObject)genericTypes.next();
                    if (!(object instanceof MetamodelType) || !(type = (MetamodelType)object).getMetaClass().getEcoreClass().equals(eClass)) continue;
                    newType.setMetamodelType(type);
                }
                commonBase = specializationType.getDiagramElement();
                commonBase.setElementType((ElementType)newType);
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Generation", (String)("Specialization type was created and has replaced the specialization type\n" + newType));
                continue;
            }
            if (!(eObject instanceof MetamodelType)) continue;
            MetamodelType metamodelType = (MetamodelType)eObject;
            genericTypeResource = this.getGenericTypeResource(metamodelType.eResource().getResourceSet());
            if (genericTypeResource == null) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"no GenericUML.gmfgen resource has been found.");
                return;
            }
            metaclass = metamodelType.getMetaClass();
            id = metamodelType.getUniqueIdentifier();
            displayName = metamodelType.getDisplayName();
            if (metaclass == null) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"metaclass is null");
                continue;
            }
            newType = GMFGenFactory.eINSTANCE.createSpecializationType();
            newType.setUniqueIdentifier(id);
            newType.setDefinedExternally(false);
            newType.setDisplayName(displayName);
            eClass = metaclass.getEcoreClass();
            genericTypes = genericTypeResource.getAllContents();
            while (genericTypes.hasNext()) {
                object = (EObject)genericTypes.next();
                if (!(object instanceof MetamodelType) || !(type = (MetamodelType)object).getMetaClass().getEcoreClass().equals(eClass)) continue;
                newType.setMetamodelType(type);
            }
            commonBase = metamodelType.getDiagramElement();
            commonBase.setElementType((ElementType)newType);
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Generation", (String)("Specialization type was created and has replaced the metamodel type\n" + newType));
        }
    }

    protected Resource getGenericTypeResource(ResourceSet resourceSet) {
        for (Resource resource : resourceSet.getResources()) {
            URI resourceURI = resource.getURI();
            String resourceName = resourceURI.segment(resourceURI.segmentCount() - 1);
            if (!GENERIC_UML_GMFGEN.equals(resourceName)) continue;
            return resource;
        }
        return null;
    }

    protected MetamodelType getGenericType(ResourceSet resourceSet, EClass eClass) {
        return null;
    }

    protected List<GenClass> getAllUMLConcreteClasses(ResourceSet resourceSet) {
        Resource umlResource = resourceSet.getResource(URI.createPlatformPluginURI((String)URI_UML_GENMODEL, (boolean)false), true);
        ArrayList<GenClass> classes = new ArrayList<GenClass>();
        TreeIterator it = umlResource.getAllContents();
        while (it.hasNext()) {
            GenClass genClass;
            EClass umlEClass;
            EObject next = (EObject)it.next();
            if (!(next instanceof GenClass) || (umlEClass = (genClass = (GenClass)next).getEcoreClass()) == null || umlEClass.isAbstract() || umlEClass.isInterface()) continue;
            classes.add(genClass);
        }
        return classes;
    }

    protected GenTopLevelNode findTopLevelNode(GenDiagram genDiagram, GenClass genClass) {
        for (GenTopLevelNode topNode : genDiagram.getTopLevelNodes()) {
            TypeModelFacet facet = topNode.getModelFacet();
            if (facet == null || !genClass.equals(facet.getMetaClass())) continue;
            return topNode;
        }
        return null;
    }

    protected void updateToplevelNode(GenTopLevelNode topLevelNode, ResourceSet resourceSet, GenClass genClass) {
        String metaclassName = genClass.getEcoreClass().getName();
        topLevelNode.setDiagramRunTimeClass(this.getNodeViewClass(resourceSet));
        TypeModelFacet typeModelFacet = topLevelNode.getModelFacet();
        if (typeModelFacet == null) {
            typeModelFacet = GMFGenFactory.eINSTANCE.createTypeModelFacet();
            topLevelNode.setModelFacet(typeModelFacet);
        }
        typeModelFacet.setMetaClass(genClass);
        ElementType type = topLevelNode.getElementType();
        if (type == null) {
            type = GMFGenFactory.eINSTANCE.createMetamodelType();
            topLevelNode.setElementType(type);
        }
        type.setDefinedExternally(true);
        type.setDisplayName(String.valueOf(metaclassName) + "_Semantic");
        type.setUniqueIdentifier(ORG_ECLIPSE_PAPYRUS_UML + metaclassName);
    }

    public GenTopLevelNode createNewTopNode(GenDiagram genDiagram, String metaclassName) {
        GenTopLevelNode topLevelNode = GMFGenFactory.eINSTANCE.createGenTopLevelNode();
        return topLevelNode;
    }

    protected GenClass getNodeViewClass(ResourceSet resourceSet) {
        URI uri_notation = URI.createPlatformPluginURI((String)URI_NOTATION_GENMODEL, (boolean)false);
        Resource notation = resourceSet.getResource(uri_notation, true);
        return this.findGenClass(notation, GEN_CLASS_RT_CLASS);
    }

    protected GenClass getMetaclassGenClass(ResourceSet resourceSet, String metaclassName) {
        URI uri_uml = URI.createPlatformPluginURI((String)URI_UML_GENMODEL, (boolean)false);
        Resource umlResource = resourceSet.getResource(uri_uml, true);
        return this.findGenClass(umlResource, metaclassName);
    }
}

