/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.internal.export.image;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.export.ExportConfigAttributes;
import org.eclipse.nebula.widgets.nattable.export.IExporter;
import org.eclipse.nebula.widgets.nattable.export.IOutputStreamProvider;
import org.eclipse.nebula.widgets.nattable.export.ITableExporter;
import org.eclipse.nebula.widgets.nattable.export.NatExporter;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.papyrus.infra.emf.utils.ResourceUtils;
import org.eclipse.papyrus.infra.nattable.export.streamprovider.PapyrusFileOutputStreamProvider;
import org.eclipse.papyrus.infra.nattable.internal.export.image.PapyrusImageExporter;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.TreeNattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.style.configattribute.PapyrusExportConfigAttributes;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.swt.widgets.Shell;

public class PapyrusNatExporter
extends NatExporter {
    private final Shell shell;

    public PapyrusNatExporter(Shell shell) {
        super(shell);
        this.shell = shell;
    }

    public void exportSingleTable(final ILayer layer, final IConfigRegistry configRegistry) {
        this.openResult = (Boolean)configRegistry.getConfigAttribute(PapyrusExportConfigAttributes.OPEN_RESULT_AFTER_EXPORT, "NORMAL", new String[0]);
        Boolean useNatTableFileDialog = (Boolean)configRegistry.getConfigAttribute(PapyrusExportConfigAttributes.EXPORT_IMAGE_USE_PAPYRUS_EXPORT_TABLE_DIALOG, "NORMAL", new String[0]);
        if (useNatTableFileDialog.booleanValue()) {
            this.setParameters(configRegistry);
            super.exportSingleTable(layer, configRegistry);
        } else {
            final ITableExporter imageExporter = (ITableExporter)configRegistry.getConfigAttribute(ExportConfigAttributes.TABLE_EXPORTER, "NORMAL", new String[0]);
            if (imageExporter == null) {
                return;
            }
            Runnable exportRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        imageExporter.exportTable(PapyrusNatExporter.this.shell, null, null, layer, configRegistry);
                        PapyrusNatExporter.this.exportSucceeded = true;
                    }
                    catch (Exception e) {
                        PapyrusNatExporter.this.exportSucceeded = false;
                        PapyrusNatExporter.this.handleExportException(e);
                    }
                    PapyrusNatExporter.this.openExport((IExporter)imageExporter);
                }
            };
            if (this.shell != null) {
                this.shell.getDisplay().asyncExec(exportRunnable);
            } else {
                exportRunnable.run();
            }
        }
    }

    protected void setParameters(IConfigRegistry configRegistry) {
        INattableModelManager modelManager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
        if (modelManager != null) {
            IOutputStreamProvider outputStreamProvider;
            ITableExporter imageExporter;
            String tableName = modelManager.getTableName();
            Table table = modelManager.getTable();
            IFile fileResource = ResourceUtils.getFile((Resource)table.eResource());
            IResource currentProjectDir = null;
            if (fileResource != null) {
                currentProjectDir = fileResource.getParent().findMember(".");
            }
            boolean isTreeTable = modelManager instanceof TreeNattableModelManager;
            if (tableName != null && !tableName.isEmpty() && currentProjectDir != null && (imageExporter = (ITableExporter)configRegistry.getConfigAttribute(ExportConfigAttributes.TABLE_EXPORTER, "NORMAL", new String[0])) instanceof PapyrusImageExporter && (outputStreamProvider = ((PapyrusImageExporter)imageExporter).getOutputStreamProvider()) instanceof PapyrusFileOutputStreamProvider) {
                NatTable natTable = (NatTable)modelManager.getAdapter(NatTable.class);
                ((PapyrusFileOutputStreamProvider)outputStreamProvider).setParameters(natTable, tableName, currentProjectDir, isTreeTable);
            }
        }
    }
}

