/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dev.pluginexplorer;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.papyrus.dev.pluginexplorer.Plugin;
import org.eclipse.papyrus.dev.pluginexplorer.PluginEntry;
import org.eclipse.papyrus.dev.pluginexplorer.PluginsContentLabelProvider;
import org.eclipse.papyrus.dev.pluginexplorer.PluginsContentProvider;
import org.eclipse.swt.events.SegmentEvent;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;

public class PluginsContentView
extends ViewPart {
    public static final String ID = "org.eclipse.papyrus.infra.core.pluginexplorer.PluginReflectorView";
    private Plugin[] plugins = Plugin.getLoadedPlugins();
    private TreeViewer tree;
    private Text field;

    public void createPartControl(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        parent.setLayout((Layout)gridLayout);
        this.field = new Text(parent, 2052);
        this.field.setLayoutData((Object)new GridData(768));
        this.field.addSegmentListener(new SegmentListener(){

            public void getSegments(SegmentEvent event) {
                if (PluginsContentView.this.tree != null) {
                    PluginsContentView.this.tree.setContentProvider((IContentProvider)new PluginsContentProvider(PluginsContentView.this.plugins, PluginsContentView.this.field.getText()));
                }
            }
        });
        Composite inner = new Composite(parent, 0);
        inner.setLayoutData((Object)new GridData(1808));
        inner.setLayout((Layout)new FillLayout());
        this.tree = new TreeViewer(inner, 2816);
        this.tree.setLabelProvider((IBaseLabelProvider)new PluginsContentLabelProvider());
        this.tree.setSorter(this.getViewerSorter());
        this.tree.setContentProvider((IContentProvider)new PluginsContentProvider(this.plugins, null));
        this.tree.setInput(PluginsContentProvider.treeRoot);
        this.tree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    Object obj = selection.getFirstElement();
                    MenuManager menuMgr = new MenuManager();
                    Menu menu = menuMgr.createContextMenu(PluginsContentView.this.tree.getControl());
                    PluginsContentView.this.tree.getControl().setMenu(menu);
                    PluginsContentView.this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)PluginsContentView.this.tree);
                    if (obj instanceof PluginEntry) {
                        PluginsContentView.this.fillMenuFor((PluginEntry)obj, menuMgr);
                    }
                }
            }
        });
    }

    public void setFocus() {
        this.field.setFocus();
    }

    private ViewerSorter getViewerSorter() {
        return new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof Bundle) {
                    Bundle b1 = (Bundle)e1;
                    Bundle b2 = (Bundle)e2;
                    return b1.getSymbolicName().compareTo(b2.getSymbolicName());
                }
                if (e1 instanceof File) {
                    File f1 = (File)e1;
                    File f2 = (File)e2;
                    return f1.getName().compareTo(f2.getName());
                }
                return super.compare(viewer, e1, e2);
            }
        };
    }

    private void fillMenuFor(final PluginEntry entry, MenuManager menu) {
        menu.add((IAction)new Action("Copy URI to clipboard"){

            public void run() {
                StringSelection transferable = new StringSelection(entry.getLogicalPath());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(transferable, null);
            }
        });
    }
}

