/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.parser.custom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.papyrus.uml.diagram.activity.parsers.MessageFormatParser;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ExceptionHandler;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.StructuredActivityNode;
import org.eclipse.uml2.uml.UMLPackage;

public class ExceptionHandlerTypeParser
extends MessageFormatParser
implements ISemanticParser {
    private static final String LINE_BREAK = System.getProperty("line.separator");

    public ExceptionHandlerTypeParser(EAttribute[] features, EAttribute[] editableFeatures) {
        super(features, editableFeatures);
    }

    public ExceptionHandlerTypeParser(EAttribute[] features) {
        super(features);
    }

    public ExceptionHandlerTypeParser() {
        super(new EAttribute[]{UMLPackage.eINSTANCE.getNamedElement_Name()});
    }

    protected EStructuralFeature getEStructuralFeature(Object notification) {
        Object feature;
        EStructuralFeature featureImpl = null;
        if (notification instanceof Notification && (feature = ((Notification)notification).getFeature()) instanceof EStructuralFeature) {
            featureImpl = (EStructuralFeature)feature;
        }
        return featureImpl;
    }

    public boolean isAffectingEvent(Object event, int flags) {
        EStructuralFeature feature = this.getEStructuralFeature(event);
        return this.isValidFeature(feature);
    }

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        StringBuffer label = new StringBuffer();
        Object obj = element.getAdapter(EObject.class);
        if (obj instanceof ExceptionHandler) {
            EList excTypes = ((ExceptionHandler)obj).getExceptionTypes();
            for (Classifier type : excTypes) {
                if (type == null || "".equals(type.getName()) || type.getName() == null) continue;
                if (label.length() > 0) {
                    label.append(LINE_BREAK);
                }
                label.append(UMLLabelInternationalization.getInstance().getLabel((NamedElement)type));
            }
        }
        return label.toString();
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        EStructuralFeature feature = this.getEStructuralFeature(notification);
        return this.isValidFeature(feature);
    }

    public List<?> getSemanticElementsBeingParsed(EObject element) {
        ArrayList<Object> semanticElementsBeingParsed = new ArrayList<Object>();
        if (element instanceof StructuredActivityNode) {
            semanticElementsBeingParsed.add((ExceptionHandler)element);
            EList excTypes = ((ExceptionHandler)element).getExceptionTypes();
            for (Classifier type : excTypes) {
                semanticElementsBeingParsed.add(type);
            }
        }
        return semanticElementsBeingParsed;
    }

    private boolean isValidFeature(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getNamedElement_Name().equals(feature) || UMLPackage.eINSTANCE.getExceptionHandler_ExceptionType().equals(feature);
    }
}

