/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.style.impl;

import org.eclipse.gmf.runtime.notation.LineStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.style.CSSLineStyle;
import org.w3c.dom.css.CSSValue;

public class CSSLineStyleDelegate
implements CSSLineStyle {
    private LineStyle lineStyle;
    private ExtendedCSSEngine engine;

    public CSSLineStyleDelegate(LineStyle lineStyle, ExtendedCSSEngine engine) {
        this.lineStyle = lineStyle;
        this.engine = engine;
    }

    @Override
    public int getCSSLineColor() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.lineStyle, "lineColor");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getLineStyle_LineColor().getDefaultValue();
            return (Integer)defaultValue;
        }
        return (Integer)this.engine.convert(cssValue, "GMFColor", null);
    }

    @Override
    public int getCSSLineWidth() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.lineStyle, "lineWidth");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getLineStyle_LineWidth().getDefaultValue();
            return (Integer)defaultValue;
        }
        return (Integer)this.engine.convert(cssValue, Integer.class, null);
    }
}

