/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.controlmode;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.gmfdiag.controlmode.ControlDiagramsCommand;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.commands.CreateControlResource;
import org.eclipse.papyrus.infra.services.controlmode.commands.RemoveControlResourceCommand;
import org.eclipse.papyrus.infra.services.controlmode.participants.IControlCommandParticipant;
import org.eclipse.papyrus.infra.services.controlmode.participants.IUncontrolCommandParticipant;

public class GMFDiagramControlParticipant
implements IControlCommandParticipant,
IUncontrolCommandParticipant {
    private static final String PARTICIPANT_ID = "org.eclipse.papyrus.infra.gmfdiag.controlmode.GMFDiagramControlParticipant";

    protected boolean setNotationTargetRequest(ControlModeRequest request) {
        URI notationURI = request.getNewURI().trimFileExtension().appendFileExtension("notation");
        ModelSet modelSet = request.getModelSet();
        if (modelSet != null) {
            Resource notationResource = null;
            try {
                notationResource = modelSet.getResource(notationURI, true);
            }
            catch (Exception e) {
                notationResource = null;
            }
            if (notationResource == null) {
                return false;
            }
            request.setTargetResource(notationResource, "notation");
            return true;
        }
        return false;
    }

    public String getID() {
        return PARTICIPANT_ID;
    }

    public ICommand getPostControlCommand(ControlModeRequest request) {
        return new ControlDiagramsCommand(request);
    }

    public ICommand getPostUncontrolCommand(ControlModeRequest request) {
        return new RemoveControlResourceCommand(request, "notation");
    }

    public ICommand getPreControlCommand(ControlModeRequest request) {
        return new CreateControlResource(request, "notation");
    }

    public ICommand getPreUncontrolCommand(ControlModeRequest request) {
        boolean result = this.setNotationTargetRequest(request);
        if (result) {
            return new ControlDiagramsCommand(request);
        }
        return UnexecutableCommand.INSTANCE;
    }

    public int getPriority() {
        return 60;
    }

    public boolean provideControlCommand(ControlModeRequest request) {
        return request.getTargetObject() instanceof EObject;
    }

    public boolean provideUnControlCommand(ControlModeRequest request) {
        boolean result = false;
        EObject objectToUncontrol = request.getTargetObject();
        if (objectToUncontrol != null) {
            URI notationURI = request.getNewURI().trimFileExtension().appendFileExtension("notation");
            ModelSet modelSet = request.getModelSet();
            result = modelSet != null && modelSet.getURIConverter().exists(notationURI, null);
        }
        return result;
    }
}

