/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.editor.welcome.internationalization.widgets.editors;

import java.util.Locale;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationPreferencesUtils;
import org.eclipse.papyrus.infra.internationalization.ui.dialogs.InternationalizationDialog;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class LanguageDialog
extends AbstractValueEditor
implements SelectionListener {
    protected final CLabel currentValueLabel;
    protected Button modifyValuesButton;
    protected final InternationalizationDialog dialog;
    protected Object value;
    protected boolean readOnly;

    public LanguageDialog(Composite parent, int style) {
        super(parent, style);
        GridData gridData = this.getDefaultLayoutData();
        this.currentValueLabel = factory.createCLabel((Composite)this, null, factory.getBorderStyle() | style);
        this.currentValueLabel.setLayoutData((Object)gridData);
        this.currentValueLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                LanguageDialog.this.editAction();
            }
        });
        this.dialog = this.createDialog(parent.getShell());
        this.createButton();
        this.updateControls();
        this.controlDecoration = new ControlDecoration((Control)this.currentValueLabel, 16512);
        gridData.horizontalIndent = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
    }

    protected InternationalizationDialog createDialog(Shell shell) {
        return new InternationalizationDialog(shell, null, false);
    }

    public void setModelObservable(IObservableValue modelProperty) {
        Object observed;
        super.setModelObservable(modelProperty);
        if (InternationalizationPreferencesUtils.isInternationalizationNeedToBeLoaded() && modelProperty instanceof IObserving && (observed = ((IObserving)modelProperty).getObserved()) instanceof URI) {
            URI resourceURI = (URI)observed;
            this.dialog.setResourceURI(resourceURI);
            String localeAsString = InternationalizationPreferencesUtils.getLocalePreference((URI)resourceURI).toString();
            this.currentValueLabel.setText(localeAsString);
        }
    }

    protected void createButton() {
        ++((GridLayout)this.getLayout()).numColumns;
        this.modifyValuesButton = factory.createButton((Composite)this, null, 8);
        this.modifyValuesButton.setImage(Activator.getDefault().getImage("/icons/Edit_12x12.gif"));
        this.modifyValuesButton.setToolTipText(Messages.ReferenceDialog_EditValue);
        this.modifyValuesButton.addSelectionListener((SelectionListener)this);
    }

    protected void editAction() {
        Locale newValue;
        int result = this.dialog.open();
        if (result == 0 && (newValue = this.dialog.getLocaleValue()) != null) {
            this.setValue(newValue.toString());
        }
    }

    protected void updateControls() {
        this.modifyValuesButton.setEnabled(!this.readOnly);
    }

    protected void updateLabel() {
        this.currentValueLabel.setText((String)this.getValue());
    }

    public Object getValue() {
        if (this.modelProperty != null) {
            return this.modelProperty.getValue();
        }
        return this.value;
    }

    protected void setValue(Object value) {
        this.value = value;
        try {
            if (this.modelProperty != null) {
                this.modelProperty.setValue(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateLabel();
        this.commit();
    }

    public Object getEditableType() {
        return Object.class;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly || !InternationalizationPreferencesUtils.isInternationalizationNeedToBeLoaded();
        this.updateControls();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void widgetSelected(SelectionEvent e) {
        Widget widget = e.widget;
        if (widget == this.modifyValuesButton) {
            this.editAction();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

