/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.papyrus.infra.widgets.util.INameResolutionHelper;
import org.eclipse.papyrus.infra.widgets.util.IPapyrusConverter;
import org.eclipse.papyrus.uml.tools.util.ReferenceContentAssistProcessor;
import org.eclipse.uml2.uml.NamedElement;

public class UMLReferenceConverter
implements IPapyrusConverter {
    protected INameResolutionHelper sharedResolutionHelper;
    protected final boolean isMany;
    public static final String ERROR_MESSAGE_NO_ELEMENT_FOUND = "No element have been found to match your string";
    public static final String ERROR_MESSAGE_SOME_ELEMENTS_NOT_FOUND = "Some elements have not been found to match your string";

    public UMLReferenceConverter(INameResolutionHelper nameResolutionHelper, boolean isMultiValued) {
        this.sharedResolutionHelper = nameResolutionHelper;
        this.isMany = isMultiValued;
    }

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return new ReferenceContentAssistProcessor(this, this.isMany);
    }

    public final Map<List<Integer>, String> getSubStringsWithTheirPositions(String listOfValueAsString) {
        Pattern pattern = Pattern.compile("([^'\\x2C]+)|('[^']+')|('(([^']*[\\x2C][^']*)))");
        Matcher matcher = pattern.matcher(listOfValueAsString);
        TreeMap<List<Integer>, String> path = new TreeMap<List<Integer>, String>(new TwoIntegerListTupleComparator());
        while (matcher.find()) {
            String substring;
            String current = matcher.group();
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            int start = matcher.start();
            int end = matcher.end();
            if (current.startsWith("'") && current.endsWith("'")) {
                current = current.substring(1, current.length() - 1);
            } else if (start - 1 >= 0 && "'".equals(substring = listOfValueAsString.substring(start - 1, start)) && !current.contains(",")) {
                current = listOfValueAsString.substring(--start, end);
            }
            indexes.add(start);
            indexes.add(end);
            path.put(indexes, current);
        }
        return path;
    }

    private List<NamedElement> getNamedElementFromString(String multiValuedString) {
        ArrayList<NamedElement> elements = new ArrayList<NamedElement>();
        List<String> names = this.splitFullStringToSubElementString(multiValuedString);
        for (String string2 : names) {
            List values = this.sharedResolutionHelper.getElementsByName(string2);
            if (values.size() <= 0) continue;
            elements.add((NamedElement)values.get(0));
        }
        return elements;
    }

    public List<String> splitFullStringToSubElementString(String multiValueAsString) {
        TreeMap res = (TreeMap)this.getSubStringsWithTheirPositions(multiValueAsString);
        return new ArrayList<String>(res.values());
    }

    protected String getElementNameWithDelimiterIfRequired(NamedElement namedElement) {
        StringBuilder builder = new StringBuilder();
        List names = this.sharedResolutionHelper.getShortestQualifiedNames((Object)namedElement, true);
        if (!names.isEmpty()) {
            String name = (String)names.get(0);
            if (name.contains(",")) {
                builder.append("'");
                builder.append(name);
                builder.append("'");
            } else {
                builder.append(name);
            }
        }
        return builder.toString();
    }

    public String getEditStringFromPrintString(String printString) {
        if (printString.contains(",")) {
            StringBuilder builder = new StringBuilder();
            builder.append("'");
            builder.append(printString);
            builder.append("'");
            return builder.toString();
        }
        return printString;
    }

    public INameResolutionHelper getUsedNameResolutionHelper() {
        return this.sharedResolutionHelper;
    }

    public List<?> getMatchingElements(String aString) {
        String lookedForString = null;
        lookedForString = aString.startsWith("'") && aString.endsWith("'") ? aString.substring(1, aString.length() - 2) : aString;
        return this.sharedResolutionHelper.getMatchingElements(lookedForString);
    }

    public List<?> getMatchingElements(Predicate p) {
        return this.sharedResolutionHelper.getMatchingElements(p);
    }

    public List<?> getElementsByName(String aString) {
        return this.sharedResolutionHelper.getElementsByName(aString);
    }

    public List<String> getShortestQualifiedNames(Object element) {
        return this.sharedResolutionHelper.getShortestQualifiedNames(element, false);
    }

    public List<String> getShortestQualifiedNames(Object element, boolean manageDuplicate) {
        return this.sharedResolutionHelper.getShortestQualifiedNames(element, manageDuplicate);
    }

    public String canonicalToDisplayValue(Object object, int flag) {
        if (object == null || "".equals(object)) {
            return "<Undefined>";
        }
        if (object instanceof Collection) {
            if (((Collection)object).isEmpty()) {
                return "";
            }
            StringBuilder builder = new StringBuilder();
            Collection coll = (Collection)object;
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                Object tmp = iter.next();
                Assert.isTrue((boolean)(tmp instanceof NamedElement));
                List<String> names = this.getShortestQualifiedNames(tmp, false);
                if (names.size() > 0) {
                    builder.append(names.get(0));
                }
                if (!iter.hasNext()) continue;
                builder.append(",");
            }
            return builder.toString();
        }
        if (object instanceof EObject) {
            EObject eobject = (EObject)object;
            Assert.isTrue((boolean)(eobject instanceof NamedElement));
            List<String> names = this.getShortestQualifiedNames(eobject, false);
            if (names.size() > 0) {
                return names.get(0);
            }
        }
        return "";
    }

    public Object displayToCanonicalValue(String string, int flag) {
        if ("".equals(string) || "<Undefined>".equals(string)) {
            return null;
        }
        Assert.isTrue((boolean)(string instanceof String));
        List<NamedElement> elements = this.getNamedElementFromString(string);
        if (elements.size() == 0) {
            return null;
        }
        if (!this.isMany && elements.size() >= 1) {
            return elements.get(0);
        }
        return elements;
    }

    public String canonicalToEditValue(Object object, int flag) {
        if (object == null || "".equals(object)) {
            return "";
        }
        if (object instanceof Collection) {
            if (((Collection)object).isEmpty()) {
                return "";
            }
            StringBuilder builder = new StringBuilder();
            Collection coll = (Collection)object;
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                Object tmp = iter.next();
                Assert.isTrue((boolean)(tmp instanceof NamedElement));
                builder.append(this.getElementNameWithDelimiterIfRequired((NamedElement)tmp));
                if (!iter.hasNext()) continue;
                builder.append(",");
            }
            return builder.toString();
        }
        if (object instanceof EObject) {
            EObject eobject = (EObject)object;
            Assert.isTrue((boolean)(eobject instanceof NamedElement));
            return this.getElementNameWithDelimiterIfRequired((NamedElement)eobject);
        }
        return "";
    }

    public Object editToCanonicalValue(String editValue, int flag) {
        if ("".equals(editValue) || "<Undefined>".equals(editValue)) {
            return null;
        }
        Assert.isTrue((boolean)(editValue instanceof String));
        List<NamedElement> elements = this.getNamedElementFromString(editValue);
        if (elements.size() == 0) {
            return null;
        }
        if (!this.isMany && elements.size() >= 1) {
            return elements.get(0);
        }
        return elements;
    }

    public String editToDisplayValue(String singleString) {
        if (singleString.startsWith("'") && singleString.endsWith("'")) {
            return singleString.substring(1, singleString.length() - 1);
        }
        return singleString;
    }

    public String displayToEditValue(String singleString) {
        if (singleString.contains(",")) {
            StringBuilder builder = new StringBuilder();
            builder.append("'");
            builder.append(singleString);
            builder.append("'");
            return builder.toString();
        }
        return singleString;
    }

    public IStatus isValidEditString(String aString) {
        if (aString == null || "".equals(aString) || "<Undefined>".equals(aString)) {
            return Status.OK_STATUS;
        }
        Object result = this.editToCanonicalValue(aString, 0);
        List<String> split = this.splitFullStringToSubElementString(aString);
        if (result == null || result instanceof Collection && ((Collection)result).isEmpty()) {
            return new Status(4, "org.eclipse.papyrus.infra.widgets", ERROR_MESSAGE_NO_ELEMENT_FOUND);
        }
        if (result instanceof Collection && ((Collection)result).size() < split.size()) {
            return new Status(4, "org.eclipse.papyrus.infra.widgets", ERROR_MESSAGE_SOME_ELEMENTS_NOT_FOUND);
        }
        return Status.OK_STATUS;
    }

    private static final class TwoIntegerListTupleComparator
    implements Comparator<List<Integer>> {
        private TwoIntegerListTupleComparator() {
        }

        @Override
        public int compare(List<Integer> o1, List<Integer> o2) {
            Assert.isTrue((o1.size() == 2 ? 1 : 0) != 0);
            Assert.isTrue((o2.size() == 2 ? 1 : 0) != 0);
            if (o1.equals(o2)) {
                return 0;
            }
            if (o1.get(0) > o2.get(0)) {
                Assert.isTrue((o1.get(1) > o2.get(1) ? 1 : 0) != 0);
                return 1;
            }
            if (o1.get(0) < o2.get(0)) {
                Assert.isTrue((o1.get(1) < o2.get(1) ? 1 : 0) != 0);
                return -1;
            }
            throw new UnsupportedOperationException("should no be possible");
        }
    }
}

