/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.validation;

import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.diagram.sequence.util.OccurrenceSpecificationHelper;
import org.eclipse.papyrus.uml.service.validation.internal.UMLDiagnostician;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class OperandDiagnostician
extends UMLDiagnostician {
    protected boolean doValidateContents(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        if (eObject instanceof MessageEnd) {
            result = this.validateMessage((MessageEnd)eObject, diagnostics, context);
        }
        if (eObject instanceof OccurrenceSpecification) {
            result &= this.validateExecutionSpecification((OccurrenceSpecification)eObject, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= super.doValidateContents(eObject, diagnostics, context);
        }
        return result;
    }

    protected boolean validateMessage(MessageEnd messageEnd, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Message message = messageEnd.getMessage();
        return message == null || this.validate((EObject)message, diagnostics, context);
    }

    protected boolean validateExecutionSpecification(OccurrenceSpecification occurrence, DiagnosticChain diagnostics, Map<Object, Object> context) {
        ExecutionSpecification execution = OccurrenceSpecificationHelper.findExecutionWith(occurrence, true);
        if (execution == null) {
            execution = OccurrenceSpecificationHelper.findExecutionWith(occurrence, false);
        }
        return execution == null || this.validate((EObject)execution, diagnostics, context);
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (context != null && (eObject instanceof Message || eObject instanceof ExecutionSpecification)) {
            HashSet<EObject> validated = (HashSet<EObject>)context.get("operand.validated");
            if (validated == null) {
                validated = new HashSet<EObject>();
                context.put("operand.validated", validated);
            }
            if (!validated.add(eObject)) {
                return true;
            }
        }
        return super.validate(eObject, diagnostics, context);
    }
}

