/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.sync;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import org.eclipse.papyrus.infra.sync.SyncFeature;
import org.eclipse.papyrus.infra.sync.SyncItem;
import org.eclipse.papyrus.infra.sync.SyncItemList;
import org.eclipse.papyrus.infra.sync.SyncObject;
import org.eclipse.papyrus.infra.sync.SyncRequest;

public abstract class SyncBucket<M, T, X>
extends SyncObject {
    private M model;
    private List<SyncFeature<M, T, X>> features;
    private SyncItemList<M, T> items;
    private Queue<SyncRequest<M, T, X>> requests;
    private SyncRequest<M, T, X> currentRequest;

    public M getModel() {
        return this.model;
    }

    public SyncBucket(M model) throws IllegalArgumentException {
        if (model == null) {
            throw new IllegalArgumentException("The model element must not be null");
        }
        this.model = model;
        this.features = Lists.newArrayListWithExpectedSize((int)2);
        this.items = new SyncItemList();
        this.requests = new ArrayDeque<SyncRequest<M, T, X>>();
    }

    boolean checkEnabled() {
        boolean result = this.isActive();
        if (!result) {
            this.clear();
        }
        return result;
    }

    public SyncItem<M, T> get(T element) throws IllegalArgumentException {
        if (element == null) {
            throw new IllegalArgumentException("The specified element must not be null");
        }
        return this.checkEnabled() ? this.items.get(element) : null;
    }

    protected Iterable<SyncItem<M, T>> getItems() {
        return this.items;
    }

    public T findBackend(final Predicate<? super T> predicate) {
        Predicate itemPredicate = new Predicate<SyncItem<M, T>>(){

            public boolean apply(SyncItem<M, T> input) {
                return predicate.apply(input.getBackend());
            }
        };
        SyncItem item = (SyncItem)Iterables.find(this.getItems(), (Predicate)itemPredicate, null);
        return item == null ? null : (T)item.getBackend();
    }

    public SyncItem<M, T> add(T element) throws IllegalArgumentException {
        if (element == null) {
            throw new IllegalArgumentException("The specified element must not be null");
        }
        if (!this.checkEnabled()) {
            return null;
        }
        SyncItem<M, T> result = this.items.get(element);
        if (result == null) {
            result = this.encapsulate(element);
            this.items.add(result);
            this.onNew(result);
        }
        return result;
    }

    public SyncItem<M, T> remove(T element) throws IllegalArgumentException {
        if (element == null) {
            throw new IllegalArgumentException("The specified element must not be null");
        }
        if (!this.checkEnabled()) {
            return null;
        }
        SyncItem<M, T> result = this.items.get(element);
        if (result != null) {
            this.items.remove(result);
        }
        return result;
    }

    public boolean synchronizes(T backend) {
        return this.items.get(backend) != null;
    }

    protected Iterable<SyncFeature<M, T, X>> getFeatures() {
        return this.features;
    }

    public void add(SyncFeature<M, T, X> feature) throws IllegalArgumentException {
        if (feature == null) {
            throw new IllegalArgumentException("The specified element must not be null");
        }
        if (!this.checkEnabled()) {
            return;
        }
        this.features.add(feature);
        this.onNew(feature);
    }

    public void remove(SyncFeature<M, T, X> feature) throws IllegalArgumentException {
        if (feature == null) {
            throw new IllegalArgumentException("The specified element must not be null");
        }
        if (!this.checkEnabled()) {
            return;
        }
        this.features.remove(feature);
    }

    public void clear() {
        for (SyncFeature<M, T, X> feature : this.features) {
            feature.clear();
        }
        this.model = null;
        this.features.clear();
        this.items.clear();
        this.requests.clear();
    }

    public void propagate(SyncFeature<M, T, X> feature, SyncItem<M, T> origin, X message) {
        if (!this.accept(feature, origin, message)) {
            return;
        }
        this.requests.add(new SyncRequest<M, T, X>(feature, origin, message));
        if (this.currentRequest == null) {
            try {
                this.currentRequest = this.requests.poll();
                while (this.currentRequest != null) {
                    this.executeCurrentRequest();
                    this.currentRequest = this.requests.poll();
                }
            }
            finally {
                this.currentRequest = null;
            }
        }
    }

    private void executeCurrentRequest() {
        SyncItem<M, T> from = this.currentRequest.getOrigin();
        SyncFeature<M, T, X> feature = this.currentRequest.getFeature();
        for (SyncItem<M, T> to : this.getSyncService().getSyncPolicy().filter(from, this.getItems(), feature)) {
            feature.synchronize(from, to, this.currentRequest.getMessage());
        }
    }

    protected abstract SyncItem<M, T> encapsulate(T var1);

    protected void onNew(SyncItem<M, T> item) {
    }

    protected void onNew(SyncFeature<M, T, X> feature) {
    }

    protected boolean accept(SyncFeature<M, T, X> feature, SyncItem<M, T> origin, X message) {
        return true;
    }
}

