/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.snap;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.ResizeTracker;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.preferences.PreferencesConstantsHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.snap.SnapUtils;

public class ResizeTrackerWithPreferences
extends ResizeTracker {
    private SnapToHelper localSnapToHelper;
    private PrecisionRectangle localSourceRect;

    public ResizeTrackerWithPreferences(GraphicalEditPart owner, int direction) {
        super(owner, direction);
    }

    public void activate() {
        super.activate();
        if (this.getOwner() != null) {
            IFigure figure;
            if (this.getTargetEditPart() != null) {
                this.localSnapToHelper = (SnapToHelper)this.getTargetEditPart().getAdapter(SnapToHelper.class);
            }
            this.localSourceRect = (figure = this.getOwner().getFigure()) instanceof HandleBounds ? new PrecisionRectangle(((HandleBounds)figure).getHandleBounds()) : new PrecisionRectangle(figure.getBounds());
            figure.translateToAbsolute((Translatable)this.localSourceRect);
        }
    }

    protected void updateSourceRequest() {
        ChangeBoundsRequest request = (ChangeBoundsRequest)this.getSourceRequest();
        Dimension d = this.getDragMoveDelta();
        Point location = new Point(this.getLocation());
        Point moveDelta = new Point(0, 0);
        Dimension resizeDelta = new Dimension(0, 0);
        request.setConstrainedResize(this.isConstrainedResizeAccordingToPreference());
        request.setCenteredResize(this.getCurrentInput().isModKeyDown(SnapUtils.MODIFIER_CENTERED_RESIZE));
        request.setSnapToEnabled(!this.getCurrentInput().isModKeyDown(SnapUtils.MODIFIER_NO_SNAPPING));
        if (!request.isConstrainedResize() && this.getOwner() != null) {
            request.setConstrainedResize(false);
            int origHeight = this.getOwner().getFigure().getBounds().height;
            int origWidth = this.getOwner().getFigure().getBounds().width;
            float ratio = 1.0f;
            if (origWidth != 0 && origHeight != 0) {
                ratio = (float)origHeight / (float)origWidth;
            }
            if (this.getResizeDirection() == 20) {
                if ((float)d.height > (float)d.width * ratio) {
                    d.width = (int)((float)d.height / ratio);
                } else {
                    d.height = (int)((float)d.width * ratio);
                }
            } else if (this.getResizeDirection() == 9) {
                if ((float)d.height < (float)d.width * ratio) {
                    d.width = (int)((float)d.height / ratio);
                } else {
                    d.height = (int)((float)d.width * ratio);
                }
            } else if (this.getResizeDirection() == 17) {
                if ((float)(-d.height) > (float)d.width * ratio) {
                    d.width = -((int)((float)d.height / ratio));
                } else {
                    d.height = -((int)((float)d.width * ratio));
                }
            } else if (this.getResizeDirection() == 12) {
                if ((float)(-d.height) < (float)d.width * ratio) {
                    d.width = -((int)((float)d.height / ratio));
                } else {
                    d.height = -((int)((float)d.width * ratio));
                }
            }
        }
        if ((this.getResizeDirection() & 1) != 0) {
            if (request.isCenteredResize()) {
                resizeDelta.height -= d.height;
            }
            moveDelta.y += d.height;
            resizeDelta.height -= d.height;
        }
        if ((this.getResizeDirection() & 4) != 0) {
            if (request.isCenteredResize()) {
                moveDelta.y -= d.height;
                resizeDelta.height += d.height;
            }
            resizeDelta.height += d.height;
        }
        if ((this.getResizeDirection() & 8) != 0) {
            if (request.isCenteredResize()) {
                resizeDelta.width -= d.width;
            }
            moveDelta.x += d.width;
            resizeDelta.width -= d.width;
        }
        if ((this.getResizeDirection() & 0x10) != 0) {
            if (request.isCenteredResize()) {
                moveDelta.x -= d.width;
                resizeDelta.width += d.width;
            }
            resizeDelta.width += d.width;
        }
        request.setMoveDelta(moveDelta);
        request.setSizeDelta(resizeDelta);
        request.setLocation(location);
        request.setEditParts(this.getOperationSet());
        request.getExtendedData().clear();
        request.setResizeDirection(this.getResizeDirection());
        if (request.isSnapToEnabled() && this.localSnapToHelper != null) {
            PrecisionRectangle rect = this.localSourceRect.getPreciseCopy();
            rect.translate(moveDelta);
            rect.resize(resizeDelta);
            PrecisionRectangle result = new PrecisionRectangle();
            this.localSnapToHelper.snapRectangle((Request)request, request.getResizeDirection(), rect, result);
            if (request.isCenteredResize()) {
                if (result.preciseX() != 0.0) {
                    result.setPreciseWidth(result.preciseWidth() - result.preciseX());
                } else if (result.preciseWidth() != 0.0) {
                    result.setPreciseX(-result.preciseWidth());
                    result.setPreciseWidth(result.preciseWidth() * 2.0);
                }
                if (result.preciseY() != 0.0) {
                    result.setPreciseHeight(result.preciseHeight() - result.preciseY());
                } else if (result.preciseHeight() != 0.0) {
                    result.setPreciseY(-result.preciseHeight());
                    result.setPreciseHeight(result.preciseHeight() * 2.0);
                }
            }
            PrecisionPoint preciseMove = new PrecisionPoint(result.preciseX() + (double)moveDelta.x, result.preciseY() + (double)moveDelta.y);
            PrecisionDimension preciseResize = new PrecisionDimension(result.preciseWidth() + (double)resizeDelta.width, result.preciseHeight() + (double)resizeDelta.height);
            request.setMoveDelta((Point)preciseMove);
            request.setSizeDelta((Dimension)preciseResize);
        }
        this.enforceConstraintsForResize(request);
    }

    private final boolean isConstrainedResizeAccordingToPreference() {
        IPreferenceStore store = Activator.getInstance().getPreferenceStore();
        boolean isInverted = false;
        if (store.contains(PreferencesConstantsHelper.getPapyrusEditorConstant(34))) {
            isInverted = store.getBoolean(PreferencesConstantsHelper.getPapyrusEditorConstant(34));
        }
        if (isInverted) {
            return !this.getCurrentInput().isModKeyDown(131072);
        }
        return this.getCurrentInput().isModKeyDown(131072);
    }
}

