/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.releng.tools.internal.popup.actions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cbi.p2repo.aggregator.Contribution;
import org.eclipse.cbi.p2repo.aggregator.MappedRepository;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public abstract class DependencyUpdater<T> {
    private final Pattern commentPattern = Pattern.compile("updateFrom\\s*\\(\\s*\"(.*?)\"\\s*,\\s*(\\d+)\\s*\\)");
    private final List<LocationUpdateStrategy> locationUpdateStrategies = ImmutableList.of((Object)new MilestoneLocationStrategy(), (Object)new EMFLocationStrategy());
    protected static final String PREFIX = "http://download.eclipse.org/";

    public abstract boolean canUpdate(IFile var1);

    protected abstract List<T> getNodesToUpdate(IFile var1) throws CoreException;

    public void updateDocument(Shell parentShell, IFile mapFile, EList<Contribution> contributions, Map<Object, Object> context) throws CoreException {
        try {
            List<T> nodesToUpdate = this.getNodesToUpdate(mapFile);
            ArrayList updates = Lists.newArrayList();
            for (T uri : nodesToUpdate) {
                String comment = this.getComment(uri);
                if (comment == null) continue;
                Matcher matcher = this.getCommentPattern().matcher(comment);
                if (matcher.find()) {
                    String contributionName = matcher.group(1);
                    int repositoryIndex = Integer.parseInt(matcher.group(2));
                    Contribution contribution = this.findContribution((Iterable<? extends Contribution>)contributions, contributionName);
                    if (contribution == null) {
                        throw new RuntimeException("'updateFrom' failed: cannot find contribution with label \"" + contributionName + "\"");
                    }
                    updates.add(new UpdateItem<T>(uri, contribution, repositoryIndex));
                    continue;
                }
                if (!comment.contains("updateFrom")) continue;
                throw new Exception("Wrong syntax for 'updateFrom' : should be " + this.getCommentSyntax());
            }
            if (this.confirmUpdates(parentShell, updates, context)) {
                for (UpdateItem next : updates) {
                    this.updateWithContribution(parentShell, next.uriNode, next.contribution, next.repositoryIndex, context);
                }
                this.save(mapFile);
                mapFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.releng.tools", "Error updating map: " + e.getLocalizedMessage(), (Throwable)e));
        }
    }

    protected abstract void save(IFile var1) throws Exception;

    protected void updateWithContribution(Shell parentShell, T uri, Contribution contribution, int repositoryIndex, Map<Object, Object> context) {
        EList repositories = contribution.getRepositories();
        if (repositoryIndex >= repositories.size()) {
            throw new RuntimeException("wrong index in updateFrom(\"" + contribution.getLabel() + "\"" + repositoryIndex + ") : there are " + repositories.size() + " contributions");
        }
        String location = ((MappedRepository)repositories.get(repositoryIndex)).getLocation();
        this.updateUri(uri, location);
    }

    protected abstract String getCurrentLocation(T var1);

    protected abstract void updateUri(T var1, String var2);

    protected Contribution findContribution(Iterable<? extends Contribution> contributions, String contributionName) {
        Contribution matchingContribution = null;
        for (Contribution contribution : contributions) {
            if (!contributionName.equalsIgnoreCase(contribution.getLabel())) continue;
            matchingContribution = contribution;
        }
        return matchingContribution;
    }

    protected abstract String getComment(T var1);

    protected Pattern getCommentPattern() {
        return this.commentPattern;
    }

    protected String getCommentSyntax() {
        return "updateFrom(\"<contributionName>\",<index>)";
    }

    private boolean promptToReplaceSingle(Shell parentShell, LocationUpdate<T> locationUpdate, Map<Object, Object> context) {
        String message = NLS.bind((String)"{0}\n\nUpdate anyways?", (Object)locationUpdate.strategy.getUpdateConfirmationMessage(locationUpdate.update, locationUpdate.oldLocation, locationUpdate.newLocation));
        boolean result = MessageDialog.openQuestion((Shell)parentShell, (String)"Confirm Location Update", (String)message);
        this.setReplace(locationUpdate.update, result, context);
        return result;
    }

    private Boolean getReplace(UpdateItem<T> update, Map<Object, Object> context) {
        return (Boolean)context.get("$replace$::" + update.contribution.getLabel());
    }

    private void setReplace(UpdateItem<T> update, Boolean replace, Map<Object, Object> context) {
        context.put("$replace$::" + update.contribution.getLabel(), replace);
    }

    private Collection<LocationUpdate<T>> promptToReplaceMultiple(Shell parentShell, Collection<? extends LocationUpdate<T>> locationUpdates, Map<Object, Object> context) {
        ArrayList result = Lists.newArrayList(locationUpdates);
        LabelProvider labels = new LabelProvider(){

            public String getText(Object element) {
                return ((LocationUpdate)element).update.contribution.getLabel();
            }
        };
        ListSelectionDialog dialog = new ListSelectionDialog(parentShell, locationUpdates, (IStructuredContentProvider)ArrayContentProvider.getInstance(), (ILabelProvider)labels, "Select dependencies to confirm updating."){

            protected Control createDialogArea(Composite parent) {
                Composite result = (Composite)super.createDialogArea(parent);
                this.createDetailsArea(result);
                return result;
            }

            void createDetailsArea(Composite parent) {
                Label label = new Label(parent, 0);
                label.setText("Details:");
                final Text details = new Text(parent, 2634);
                GridData data = new GridData(1808);
                data.heightHint = details.getLineHeight() * 4;
                details.setLayoutData((Object)data);
                this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                        if (sel.isEmpty()) {
                            details.setText("");
                        } else {
                            LocationUpdate update = (LocationUpdate)sel.getFirstElement();
                            details.setText(update.strategy.getUpdateConfirmationMessage(update.update, update.oldLocation, update.newLocation));
                        }
                    }
                });
            }
        };
        dialog.setInitialElementSelections((List)result);
        dialog.setTitle("Confirm Location Update");
        if (dialog.open() == 0) {
            ImmutableSet toUpdate = ImmutableSet.copyOf((Object[])dialog.getResult());
            Iterator iter = result.iterator();
            while (iter.hasNext()) {
                LocationUpdate next = (LocationUpdate)iter.next();
                boolean update = toUpdate.contains(next);
                this.setReplace(next.update, update, context);
                if (update) continue;
                iter.remove();
            }
        } else {
            throw new OperationCanceledException();
        }
        return result;
    }

    private boolean confirmUpdates(Shell parentShell, List<UpdateItem<T>> updates, Map<Object, Object> context) {
        HashMap toPrompt = Maps.newHashMap();
        Iterator<UpdateItem<T>> iter = updates.iterator();
        while (iter.hasNext()) {
            LocationUpdateStrategy strategy;
            UpdateItem<T> next = iter.next();
            Boolean previousAnswer = this.getReplace(next, context);
            if (previousAnswer != null) {
                if (previousAnswer.booleanValue()) continue;
                iter.remove();
                continue;
            }
            EList repositories = next.contribution.getRepositories();
            if (next.repositoryIndex >= repositories.size()) {
                throw new RuntimeException("wrong index in updateFrom(\"" + next.contribution.getLabel() + "\"" + next.repositoryIndex + ") : there are " + repositories.size() + " contributions");
            }
            String location = ((MappedRepository)repositories.get(next.repositoryIndex)).getLocation();
            String current = this.getCurrentLocation(next.uriNode);
            if (current != null && current.equals(location) || current == null || current.isEmpty() || (strategy = this.findLocationUpdateStrategy(next, current, location)) == null) continue;
            toPrompt.put(next, new LocationUpdate<T>(next, strategy, current, location));
        }
        if (!toPrompt.isEmpty()) {
            if (toPrompt.size() == 1) {
                UpdateItem update = (UpdateItem)Iterables.getOnlyElement(toPrompt.keySet());
                LocationUpdate location = (LocationUpdate)toPrompt.get(update);
                if (!this.promptToReplaceSingle(parentShell, location, context)) {
                    updates.remove(update);
                }
            } else {
                toPrompt.values().removeAll(this.promptToReplaceMultiple(parentShell, toPrompt.values(), context));
                updates.removeAll(toPrompt.keySet());
            }
        }
        return !updates.isEmpty();
    }

    private LocationUpdateStrategy findLocationUpdateStrategy(UpdateItem<T> update, String oldLocation, String newLocation) {
        LocationUpdateStrategy result = null;
        for (LocationUpdateStrategy next : this.locationUpdateStrategies) {
            if (next.shouldAutoUpdate(update, oldLocation, newLocation)) continue;
            result = next;
            break;
        }
        return result;
    }

    static class EMFLocationStrategy
    implements LocationUpdateStrategy {
        private final Pattern typicalMilestonesPattern = Pattern.compile("\\d+\\.\\d+(milestones|interim)$");

        EMFLocationStrategy() {
        }

        @Override
        public boolean shouldAutoUpdate(UpdateItem<?> update, String oldLocation, String newLocation) {
            boolean foundNew;
            boolean result = true;
            Matcher oldMatcher = this.typicalMilestonesPattern.matcher(oldLocation);
            Matcher newMatcher = this.typicalMilestonesPattern.matcher(newLocation);
            boolean foundOld = oldMatcher.find();
            if (foundOld != (foundNew = newMatcher.find())) {
                result = false;
            } else if (foundNew && !oldMatcher.group(1).equals(newMatcher.group(1))) {
                result = oldMatcher.group(1).equals("interim");
            }
            return result;
        }

        @Override
        public String getUpdateConfirmationMessage(UpdateItem<?> update, String oldLocation, String newLocation) {
            return NLS.bind((String)"The current location \"{2}\" for project \"{1}\" provides interim builds. Updating from \"{0}\" could roll back to a previous milestone build.", (Object[])new Object[]{newLocation, update.contribution.getLabel(), oldLocation});
        }
    }

    private static class LocationUpdate<T> {
        final UpdateItem<T> update;
        final LocationUpdateStrategy strategy;
        final String oldLocation;
        final String newLocation;

        LocationUpdate(UpdateItem<T> update, LocationUpdateStrategy strategy, String oldLocation, String newLocation) {
            this.update = update;
            this.strategy = strategy;
            this.oldLocation = oldLocation;
            this.newLocation = newLocation;
        }
    }

    private static interface LocationUpdateStrategy {
        public static final Pattern URL_PREFIX_PATTERN = Pattern.compile("^(?:\\$\\{[^}]+\\}/|\\Qhttp://download.eclipse.org/\\E)");

        public boolean shouldAutoUpdate(UpdateItem<?> var1, String var2, String var3);

        public String getUpdateConfirmationMessage(UpdateItem<?> var1, String var2, String var3);

        default public boolean hasRecognizedURLPrefix(String location) {
            return URL_PREFIX_PATTERN.matcher(location).find();
        }

        default public String stripRecognizedURLPrefix(String location) {
            Matcher m = URL_PREFIX_PATTERN.matcher(location);
            return !m.find() ? location : location.substring(m.end());
        }

        default public boolean matchURLPattern(Pattern urlPattern, String oldLocation, String newLocation) {
            boolean foundNew;
            boolean result = true;
            Matcher oldMatcher = urlPattern.matcher(oldLocation);
            Matcher newMatcher = urlPattern.matcher(newLocation);
            boolean foundOld = oldMatcher.find();
            if (foundOld != (foundNew = newMatcher.find())) {
                result = false;
            } else if (foundNew) {
                String oldPrefix = oldLocation.substring(0, oldMatcher.start());
                String newPrefix = newLocation.substring(0, newMatcher.start());
                if (this.hasRecognizedURLPrefix(oldPrefix) && this.hasRecognizedURLPrefix(newPrefix)) {
                    oldPrefix = this.stripRecognizedURLPrefix(oldPrefix);
                    newPrefix = this.stripRecognizedURLPrefix(newPrefix);
                }
                result = newPrefix.equals(oldPrefix);
            }
            return result;
        }
    }

    static class MilestoneLocationStrategy
    implements LocationUpdateStrategy {
        private final Pattern typicalBuildTimestampPattern = Pattern.compile("[NISMR](?:-\\d+\\.\\d+(?:\\.\\d+)?(?:M|RC)\\d[abcd]-)?20\\d\\d[-0-9]+");

        MilestoneLocationStrategy() {
        }

        @Override
        public boolean shouldAutoUpdate(UpdateItem<?> update, String oldLocation, String newLocation) {
            return this.matchURLPattern(this.typicalBuildTimestampPattern, oldLocation, newLocation);
        }

        @Override
        public String getUpdateConfirmationMessage(UpdateItem<?> update, String oldLocation, String newLocation) {
            return NLS.bind((String)"The new location \"{0}\" for project \"{1}\" is not like the current location \"{2}\". This could roll back to an older (obsolete) build.", (Object[])new Object[]{newLocation, update.contribution.getLabel(), oldLocation});
        }
    }

    private static class UpdateItem<T> {
        final T uriNode;
        final Contribution contribution;
        final int repositoryIndex;

        UpdateItem(T uriNode, Contribution contribution, int repositoryIndex) {
            this.uriNode = uriNode;
            this.contribution = contribution;
            this.repositoryIndex = repositoryIndex;
        }
    }
}

