/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.matchers;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;
import org.eclipse.papyrus.infra.services.decoration.DecorationService;
import org.eclipse.papyrus.infra.services.decoration.IDecorationService;
import org.eclipse.papyrus.infra.services.decoration.util.IPapyrusDecoration;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class DiagramMatchers {
    private DiagramMatchers() {
    }

    public static Matcher<EditPart> editPartSelected() {
        return EditPartSelected.INSTANCE;
    }

    public static Matcher<PaletteDrawer> expandedIn(PaletteViewer viewer) {
        return new DrawerExpansion(viewer, true);
    }

    public static Matcher<PaletteDrawer> collapsedIn(PaletteViewer viewer) {
        return new DrawerExpansion(viewer, false);
    }

    public static Matcher<EditPart> viewThat(final Matcher<? super View> viewMatcher) {
        return new TypeSafeDiagnosingMatcher<EditPart>(){

            public void describeTo(Description description) {
                description.appendText("view that ").appendDescriptionOf((SelfDescribing)viewMatcher);
            }

            protected boolean matchesSafely(EditPart item, Description mismatchDescription) {
                boolean result = false;
                if (!(item.getModel() instanceof View)) {
                    mismatchDescription.appendText("edit-part model is not a notation view");
                } else {
                    View view = (View)item.getModel();
                    result = viewMatcher.matches((Object)view);
                    if (!result) {
                        viewMatcher.describeMismatch((Object)view, mismatchDescription);
                    }
                }
                return result;
            }
        };
    }

    public static Matcher<View> elementThat(final Matcher<? super EObject> elementMatcher) {
        return new TypeSafeDiagnosingMatcher<View>(){

            public void describeTo(Description description) {
                description.appendText("element that ").appendDescriptionOf((SelfDescribing)elementMatcher);
            }

            protected boolean matchesSafely(View item, Description mismatchDescription) {
                boolean result = false;
                EObject element = item.getElement();
                if (element == null) {
                    mismatchDescription.appendText("view has no semantic element");
                } else {
                    result = elementMatcher.matches((Object)element);
                    if (!result) {
                        elementMatcher.describeMismatch((Object)element, mismatchDescription);
                    }
                }
                return result;
            }
        };
    }

    public static Matcher<EditPart> semanticThat(Matcher<? super EObject> elementMatcher) {
        return DiagramMatchers.viewThat(DiagramMatchers.elementThat(elementMatcher));
    }

    public static Matcher<EditPart> hasErrorDecorationThat(Matcher<? super String> messageMatcher) {
        return DiagramMatchers.hasDecorationThat(2, messageMatcher);
    }

    public static Matcher<EditPart> hasWarningDecorationThat(Matcher<? super String> messageMatcher) {
        return DiagramMatchers.hasDecorationThat(1, messageMatcher);
    }

    public static Matcher<EditPart> hasDecorationThat(final int severity, final Matcher<? super String> messageMatcher) {
        return new TypeSafeDiagnosingMatcher<EditPart>(){

            public void describeTo(Description description) {
                description.appendText("has error decoration that ").appendDescriptionOf((SelfDescribing)messageMatcher);
            }

            protected boolean matchesSafely(EditPart item, Description mismatchDescription) {
                IDecorationService service = null;
                try {
                    service = (IDecorationService)ServiceUtilsForEditPart.getInstance().getService(IDecorationService.class, (Object)item);
                }
                catch (Exception e) {
                    try {
                        service = (IDecorationService)ServiceUtilsForEditPart.getInstance().getService(DecorationService.class, (Object)item);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (service == null) {
                    mismatchDescription.appendText("no decoration service");
                    return false;
                }
                List decorations = service.getDecorations((Object)item, false);
                List messages = decorations.stream().filter(d -> d.getPriority() == severity).map(IPapyrusDecoration::getMessage).collect(Collectors.toList());
                Matcher delegate = CoreMatchers.hasItem((Matcher)messageMatcher);
                boolean result = delegate.matches(messages);
                if (!result) {
                    delegate.describeMismatch(messages, mismatchDescription);
                }
                return result;
            }
        };
    }

    static class DrawerExpansion
    extends BaseMatcher<PaletteDrawer> {
        private final PaletteViewer viewer;
        private final boolean expanded;

        DrawerExpansion(PaletteViewer viewer, boolean expanded) {
            this.viewer = viewer;
            this.expanded = expanded;
        }

        public void describeTo(Description description) {
            description.appendText("drawer is ");
            description.appendText(this.expanded ? "expanded" : "collapsed");
        }

        public boolean matches(Object item) {
            return item instanceof PaletteDrawer && this.isExpanded((PaletteDrawer)item) == this.expanded;
        }

        boolean isExpanded(PaletteDrawer drawer) {
            return this.viewer.isExpanded(drawer);
        }
    }

    static class EditPartSelected
    extends BaseMatcher<EditPart> {
        private static final EditPartSelected INSTANCE = new EditPartSelected();

        private EditPartSelected() {
        }

        public void describeTo(Description description) {
            description.appendText("edit-part is selected");
        }

        public boolean matches(Object item) {
            return item instanceof EditPart && this.isSelected((EditPart)item);
        }

        boolean isSelected(EditPart editPart) {
            EditPartViewer viewer = editPart.getViewer();
            return viewer != null && viewer.getSelectedEditParts().contains(editPart);
        }
    }
}

