/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.sync;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.sync.EMFDispatch;
import org.eclipse.papyrus.infra.sync.internal.SyncService;
import org.eclipse.papyrus.infra.sync.internal.SyncServiceOperation;
import org.eclipse.papyrus.infra.sync.service.ISyncService;
import org.eclipse.papyrus.infra.sync.service.SyncServiceRunnable;

public class EMFListener
implements ResourceSetListener {
    private final ISyncService syncService = SyncService.getCurrent();
    private TransactionalEditingDomain domain;
    private Map<EObject, Map<EStructuralFeature, List<EMFDispatch>>> dispatchers = Maps.newLinkedHashMap();

    public EMFListener(TransactionalEditingDomain domain) {
        this.domain = domain;
        domain.addResourceSetListener((ResourceSetListener)this);
    }

    public void dispose() {
        this.dispatchers.clear();
        if (this.domain != null) {
            this.domain.removeResourceSetListener((ResourceSetListener)this);
            this.domain = null;
        }
    }

    public void add(EMFDispatch dispatcher) {
        ArrayList<EMFDispatch> sub2;
        EObject notifier = dispatcher.getNotifier();
        EStructuralFeature feature = dispatcher.getFeature();
        LinkedHashMap sub1 = this.dispatchers.get(notifier);
        if (sub1 == null) {
            sub1 = Maps.newLinkedHashMap();
            this.dispatchers.put(notifier, sub1);
        }
        if ((sub2 = (ArrayList<EMFDispatch>)sub1.get(dispatcher.getFeature())) == null) {
            sub2 = new ArrayList<EMFDispatch>();
            sub1.put(feature, sub2);
        }
        sub2.add(dispatcher);
    }

    public void remove(EMFDispatch dispatcher) {
        Map<EStructuralFeature, List<EMFDispatch>> sub1 = this.dispatchers.get(dispatcher.getNotifier());
        if (sub1 == null) {
            return;
        }
        List<EMFDispatch> sub2 = sub1.get(dispatcher.getFeature());
        if (sub2 == null) {
            return;
        }
        sub2.remove(dispatcher);
    }

    public NotificationFilter getFilter() {
        return NotificationFilter.NOT_TOUCH;
    }

    public boolean isAggregatePrecommitListener() {
        return false;
    }

    public boolean isPrecommitOnly() {
        return true;
    }

    public boolean isPostcommitOnly() {
        return false;
    }

    public void resourceSetChanged(ResourceSetChangeEvent arg0) {
    }

    public Command transactionAboutToCommit(final ResourceSetChangeEvent event) throws RollbackException {
        return this.syncService.run(new SyncServiceRunnable.Safe<Command>(){
            private List<EMFDispatch> cache = Lists.newArrayList();

            @Override
            public Command run(ISyncService syncService) {
                SyncServiceCommandWrapper result = null;
                CompoundCommand compound = null;
                for (Notification notification : event.getNotifications()) {
                    Object objNotifier = notification.getNotifier();
                    Object objFeature = notification.getFeature();
                    if (!(objNotifier instanceof EObject) || !(objFeature instanceof EStructuralFeature)) continue;
                    EObject notifier = (EObject)objNotifier;
                    EStructuralFeature feature = (EStructuralFeature)objFeature;
                    this.addToCache(null, null);
                    this.addToCache(notifier, null);
                    this.addToCache(null, feature);
                    this.addToCache(notifier, feature);
                    if (this.cache.isEmpty()) continue;
                    if (result == null) {
                        compound = new CompoundCommand();
                        result = new SyncServiceCommandWrapper(syncService, (Command)compound);
                    }
                    for (EMFDispatch option : this.cache) {
                        option.dispatch(notification, compound);
                    }
                    this.cache.clear();
                }
                return result;
            }

            private void addToCache(EObject notifier, EStructuralFeature feature) {
                Map sub1 = (Map)EMFListener.this.dispatchers.get(notifier);
                if (sub1 == null) {
                    return;
                }
                List sub2 = (List)sub1.get(feature);
                if (sub2 == null) {
                    return;
                }
                for (EMFDispatch dispatch : sub2) {
                    if (this.cache.contains(dispatch)) continue;
                    this.cache.add(dispatch);
                }
            }
        });
    }

    private static class SyncServiceCommandWrapper
    extends CommandWrapper {
        private final SyncService syncService;

        SyncServiceCommandWrapper(ISyncService syncService, Command command) {
            super(command);
            this.syncService = (SyncService)syncService;
        }

        public void execute() {
            new SyncServiceOperation<Void>(this.syncService){

                @Override
                protected Void doCall() throws Exception {
                    SyncServiceCommandWrapper.super.execute();
                    return null;
                }
            }.safeCall();
        }

        public void undo() {
            new SyncServiceOperation<Void>(this.syncService){

                @Override
                protected Void doCall() throws Exception {
                    SyncServiceCommandWrapper.super.undo();
                    return null;
                }
            }.safeCall();
        }

        public void redo() {
            new SyncServiceOperation<Void>(this.syncService){

                @Override
                protected Void doCall() throws Exception {
                    SyncServiceCommandWrapper.super.redo();
                    return null;
                }
            }.safeCall();
        }
    }
}

